 echo off

 REM gmssetup.bat
 REM ============

 REM This file is part of Gerolf Markup Shredder,
 REM written by G. D. Brettschneider (1999-2008). All rights reserved.
 REM Send corrections to: MarkupShredder(at)Gerolf.org (www.Gerolf.org)

 set GMS_DATE=20080107
 set GMS_VERSION=0.08a

 REM ==========================================================================

 REM Initialize debugging mode, main codepage, linking mode:

 set GMS_DEBUG=0
 set GMS_CODEPAGE=CP1252
 set GMS_LINKS=internal
 
 REM Start shell: -------------------------------------------------------------

 cls
 echo  Running ...
 if "%1" == "-shell" goto fi_sh
 if "%2" == "-shell" goto fi_sh  
   if "%comspec%" == "" echo Please set COMSPEC variable. Press any key ...
   if "%comspec%" == "" pause > nul
   if "%comspec%" == "" goto fi_sh
   %comspec% /E:4096 /C %0 -shell %1
   set GMS_VERSION=
   set GMS_DEBUG=
   set GMS_CODEPAGE=
   set GMS_LINKS=
   goto tixe
 :fi_sh
 shift
  
 REM Check operating system: --------------------------------------------------
    
 REM Assume support for long filenames if environment variable OS is defined: 
   set any=*.*
   if "%OS%" == "" set any=nul
   
 REM FreeDOS:
   if not "%OS%" == "" goto fi_fd
     if exist C:\kernel.sys if not exist C:\msdos.sys set GMS_FreeDOS=FreeDOS
   :fi_fd
   
 REM DRDOS:
   if "%OS%" == "DRDOS" set GMS_DRDOS=6
   if not "%DRDOSCFG%" == "" set GMS_DRDOS=7
   if "%OS%" == "DRDOS" set OS=
   if not "%GMS_DRDOS%" == "" goto fi_os
      
 REM Windows 9x:
   if "%OS%" == "" if not "%winbootdir%" == "" set OS=Windows_9x
   if "%OS%" == "Windows_9x" if "%winbootdir%" == "." set OS=
   if "%OS%" == "Windows_9x" set any=nul
   if "%windir%" == "" if not "%winbootdir%" == "" set GMS_DOSMODE=1
   if "%windir%" == "" if "%winbootdir%" == "." set GMS_DOSMODE=
   if not "%GMS_DOSMODE%" == "" set windir=%winbootdir%
   if exist "%windir%\Desktop\%any%" set GMS_LINKDIR=%windir%\Desktop
   if exist "%windir%\SendTo\%any%" set GMS_SENDDIR=%windir%\SendTo
   if not exist "%windir%\STARTM~1\%any%" goto fi_no9xA
     set GMS_MENUDIR=%windir%\STARTM~1
   :fi_no9xA
   if not exist "%windir%\STARTM~1\PROGRAMS\%any%" goto fi_no9xB
     set GMS_MENUDIR=%windir%\STARTM~1\PROGRAMS
   :fi_no9xB
   if not exist "%windir%\STARTM~1\PROGRA~1\%any%" goto fi_no9xC
     set GMS_MENUDIR=%windir%\STARTM~1\PROGRA~1
   :fi_no9xC
      
 REM Windows NT:
   if "%USERPROFILE%" == "" goto fi_nontC
   if not exist "%USERPROFILE%\Desktop\%any%" goto fi_nont0
     set GMS_LINKDIR=%USERPROFILE%\Desktop
   :fi_nont0
   if not exist "%USERPROFILE%\SendTo\%any%" goto fi_nont1
     set GMS_SENDDIR=%USERPROFILE%\SendTo
   :fi_nont1
   if not exist "%USERPROFILE%\STARTM~1\%any%" goto fi_nontA
     set GMS_MENUDIR=%USERPROFILE%\STARTM~1
   :fi_nontA
   if not exist "%USERPROFILE%\STARTM~1\PROGRAMS\%any%" goto fi_nontB
     set GMS_MENUDIR=%USERPROFILE%\STARTM~1\PROGRAMS
   :fi_nontB
   if not exist "%USERPROFILE%\STARTM~1\PROGRA~1\%any%" goto fi_nontC
     set GMS_MENUDIR=%USERPROFILE%\STARTM~1\PROGRA~1
   :fi_nontC
   
 REM Windows XP:
   if "%ALLUSERSPROFILE%" == "" goto fi_noxpC
   if not exist "%ALLUSERSPROFILE%\Desktop\%any%" goto fi_noxp0
     set GMS_LINKDIR=%ALLUSERSPROFILE%\Desktop
     if "%OS%" == "Windows_NT" set OS=Windows_XP
   :fi_noxp0
   if not exist "%ALLUSERPROFILE%\STARTM~1\%any%" goto fi_noxpA
     set GMS_MENUDIR=%ALLUSERPROFILE%\STARTM~1
   :fi_noxpA
   if not exist "%ALLUSERPROFILE%\STARTM~1\PROGRAMS\%any%" goto fi_noxpB
     set GMS_MENUDIR=%ALLUSERPROFILE%\STARTM~1\PROGRAMS
   :fi_noxpB
   if not exist "%ALLUSERPROFILE%\STARTM~1\PROGRA~1\%any%" goto fi_noxpC
     set GMS_MENUDIR=%ALLUSERPROFILE%\STARTM~1\PROGRA~1
   :fi_noxpC   
 :fi_os
    
 REM Windows 3x (set "WINDIR" to the content of "windir"):
   set | find "windir" > }{.bat
   echo set windir=%%1> windir.bat
   call }{
   del }{.bat
   del windir.bat
      
 REM Welcome message: ---------------------------------------------------------

 if "%GMS_FreeDOS%" == "" mode con lines=25 > nul
 if not "%GMS_FreeDOS%" == "" mode co80,25
 cls 
 set left=Running:      GMS setup ...
 if not "%1" == "" set left=Running:      GMS quick setup ...
 if "%1" == "-no_shell" set left=Running:      GMS setup ...
   set right=Gerolf Markup Shredder %GMS_VERSION%
     if "%1" == "" echo  %left%                       %right%
     if not "%1" == "" echo  %left%                 %right%
   set left=
 set right=
 set arg=///////////////////////////////////////
 if "%OS%" == "Windows_9x" set arg=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 if "%winbootdir%" == "." set arg=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
   echo  %arg%%arg%
 set arg=
 echo.
 
 REM Assume support for long filenames if environment variable OS is defined:
 REM if "%OS%" == "" if not "%winbootdir%" == "" set OS=Windows_9x
 REM if "%OS%" == "Windows_9x" if "%winbootdir%" == "." set OS=
   
 set hallo=www.ctan.org, www.tug.org, www.dante.de
   if "%OS%" == "Windows_9x" goto fi_w91
     if not "%OS%" == "" title Welcome to the TeX World - %hallo%> nul
   :fi_w91
 set hallo=

 REM Windows 9x DOSmode message: ----------------------------------------------
  
   goto fi_dm
   if "%GMS_DOSMODE%" == "" goto fi_dm
     echo                This application does not support DOS mode
     echo.               on %OS%/ME, sorry.
     echo.
     echo                Please start the graphical user interface
     echo                by entering the 'win' command and run 
     echo                  [GMS_ROOT]\etc\gmssetup.bat
     echo                in a console window by clicking on it in
     echo                Windows Explorer.
     echo.
     set any=
     set arg=
     set GMSdateGMSUNZIP=
     set GMS_CODEPAGE=
     set GMS_DATE=
     set GMS_DEBUG=
     set GMS_DOSMODE=
     set GMS_LINKDIR=
     set GMS_MENUDIR=
     set GMS_SENDDIR=
     set GMS_VERSION=
     set left=
     set OS=
     set right=
     set windir=
     goto tixe
   :fi_dm
   
 REM Get folder location: =====================================================

 REM Get GMS_SETTING (current directory):
 REM pwd.sys just contains the command "set PWD=":
   copy pwd.sys pwd_tmp.bat > nul
   cd>> pwd_tmp.bat
   if exist pwd_tmp.bat call pwd_tmp
   if exist pwd_tmp.bat del pwd_tmp.bat
 set GMS_SETTING=%PWD%

 REM Debug: -------------------------------------------------------------------

 REM Called batches may contribute to gmsdebug.log. 
 REM Renaming to gmssetup.log takes place at the end of this gmssetup script.
   set Z=gmsdebug.log
   if "%OS%" == "" goto fi_debug
     REM Remove old log files in curent folder:
       if exist gmssetup.log del gmssetup.log
       if exist gmsdebug.log del gmsdebug.log
     REM gmssetup log file header:
       echo  gmssetup.log> %Z%
       set arg=////////////////////////////////////////
      if "%OS%" == "Windows_9x" set arg=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
       if "%winbootdir%" == "." set arg=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
         echo %arg%%arg%>> %Z%
       set arg=
       echo  This is the setup log file for Gerolf Markup Shredder.>> %Z%
       echo  To write the run time debug log file, set GMS_DEBUG=Z.>> %Z%
       echo  Format: called batch  (parameter 1) ... (parameter 9),>> %Z%
       echo  followed by values of important environment variables.>> %Z%
       echo  shredder.bat reads user input and calls batch modules.>> %Z%
       echo  l_type modules only contribute if their compiled equi->> %Z%
       echo  valents are absent.>> %Z%
       echo.>> %Z%
     REM gmssetup parameters and environment variables:
       echo %0 (%1) (%2) (%3) (%4) (%5) (%6) (%7) (%8) (%9)>> %Z%
       echo   GMS_VERSION=%GMS_VERSION%>> %Z%
       echo   GMS_CODEPAGE=%GMS_CODEPAGE%>> %Z%
       echo   GMS_SETTING=%GMS_SETTING%>> %Z%
   :fi_debug
   if not "%OS%" == "" set Z="%GMS_SETTING%\gmsdebug.log"
   
 REM Go up one level and call it GMS_ROOT: ------------------------------------

 cd ..
 echo  Defining:     Installation directories ...
   if "%OS%" == "" copy %GMS_SETTING%\pwd.sys pwd_tmp.bat > nul
   if not "%OS%" == "" copy "%GMS_SETTING%\pwd.sys" pwd_tmp.bat > nul
   cd>> pwd_tmp.bat
   if exist pwd_tmp.bat call pwd_tmp.bat
   if exist pwd_tmp.bat del pwd_tmp.bat
   if exist pwd.bat del pwd.bat
 REM Directory name shall not end with a slash:
 if "%PWD%" == "A:\" set PWD=A:
 if "%PWD%" == "B:\" set PWD=B:
 if "%PWD%" == "C:\" set PWD=C:
 if "%PWD%" == "D:\" set PWD=D:
 if "%PWD%" == "E:\" set PWD=E:
 if "%PWD%" == "F:\" set PWD=F:
 if "%PWD%" == "G:\" set PWD=G:
 if "%PWD%" == "H:\" set PWD=H:
 if "%PWD%" == "I:\" set PWD=I:
 if "%PWD%" == "J:\" set PWD=J:
 if "%PWD%" == "K:\" set PWD=K:
 if "%PWD%" == "L:\" set PWD=L:
 if "%PWD%" == "M:\" set PWD=M:
 if "%PWD%" == "N:\" set PWD=N:
 if "%PWD%" == "O:\" set PWD=O:
 if "%PWD%" == "P:\" set PWD=P:
 if "%PWD%" == "Q:\" set PWD=Q:
 if "%PWD%" == "R:\" set PWD=R:
 if "%PWD%" == "S:\" set PWD=S:
 if "%PWD%" == "T:\" set PWD=T:
 if "%PWD%" == "U:\" set PWD=U:
 if "%PWD%" == "V:\" set PWD=V:
 if "%PWD%" == "W:\" set PWD=W:
 if "%PWD%" == "X:\" set PWD=X:
 if "%PWD%" == "Y:\" set PWD=Y:
 if "%PWD%" == "Z:\" set PWD=Z:
 set GMS_ROOT=%PWD%
 echo  GMS_ROOT:       %PWD%
 if not "%OS%" == "" echo   GMS_ROOT=%GMS_ROOT%>> %Z%

 REM Load folders, check if there's a folder for temorary files, backup path: -

 if "%OS%" == "" if exist %GMS_SETTING%\%any% cd %GMS_SETTING%
 if not "%OS%" == "" if exist "%GMS_SETTING%\%any%" cd "%GMS_SETTING%" 
 if not "%GMS_DRDOS%" == "" cd %GMS_SETTING%
 if not "%OS%" == "" if not "%OS%" == "Windows_9x" cd "%GMS_SETTING%" 2> nul
 if not exist folder.bat echo  Missing:      Folder configuration file.
 if exist folder.bat call folder called_by gmssetup 
 if not "%GMS_DRDOS%" == "" echo Delete me! > %GMS_TEMP%\deleteme.txt > nul
 if "%OS%" == "" if not exist %GMS_TEMP%\%any% md %GMS_TEMP% > nul
 if not "%OS%" == "" if not exist "%GMS_TEMP%\%any%" md "%GMS_TEMP%" > nul

 if not "%GMS_PATH%" == "" goto fi_path
   set GMS_PATH=%PATH%
   if "%DRDOSCFG%" == "" goto elsedr7
     path %GMS_BATCH%;%GMS_BINARIES%;%PATH%
     goto fi_dr7
   :elsedr7
     if not "%OS%" == "Windows_9x" set PATH=%GMS_BATCH%;%GMS_BINARIES%;%PATH%
     if "%OS%" == "Windows_9x" set PATH="%GMS_BINARIES%";"%PATH%"
     if "%OS%" == "Windows_9x" set PATH="%GMS_BATCH%";"%PATH%"
   :fi_dr7
   if "%OS%" == "" goto fi_path
     echo   GMS_PATH=%GMS_PATH%>> %Z%
     echo   PATH=%PATH%>> %Z%
 :fi_path

 REM Get GMS_DRIVE: -----------------------------------------------------------

 REM drv.sys just contains the command "set drv=":
 set dlist=%GMS_TEMP%\drv.lst
 set batch=%GMS_TEMP%\drv.bat
   if "%OS%" == "" copy %GMS_SETTING%\drv.sys %batch% > nul
   if not "%OS%" == "" copy "%GMS_SETTING%\drv.sys" "%batch%" > nul
   cd> %dlist%
   if "%OS%" == "" %GMS_BINARIES%\sed "s/:.*/:/" < %dlist% >> %batch%
   if not "%OS%" == "" "%GMS_BINARIES%\sed" "s/:.*/:/" < %dlist% >> %batch%
   if exist %batch% call %batch%
   set GMS_DRIVE=%DRV%
     if not "%OS%" == "" echo   GMS_DRIVE=%GMS_DRIVE%>> %Z%
   set DRV=
   if "%OS%" == "" goto else_gd
   if "%OS%" == "Windows_9x" goto else_gd
     if exist %dlist% del %dlist% > nul 2> nul
     if exist %batch% del %batch% > nul 2> nul
     goto fi_gd
   :else_gd
     if exist %dlist% del %dlist% > nul
     if exist %batch% del %batch% > nul
   :fi_gd
 set dlist=
 set batch=

 REM Setting variables: =======================================================

 REM Browser interface variables:
   REM Maximal size and number of files:
     set GMS_MAXSIZE=1234567
     set GMS_MAXFILES=123
   REM Width of text area (join/split): 
     set GMS_WIDTH_ONE=60
     set GMS_WIDTH_TWO=40
   REM Height of text area (join/split):
     set GMS_HEIGHT_ONE=30
     set GMS_HEIGHT_TWO=40
   REM Font size, in point (join/split):
     set GMS_SIZE_ONE=10
     set GMS_SIZE_TWO=8

 REM Textmode interface variables: --------------------------------------------

 REM Initialize colors & pattern (R: set by random) and animation mode:
   REM Foreground colors:
     set GMS_TEXT=R
     set GMS_HOTKEY=R
     set GMS_PATTERN=R
   REM Background colors:
     set GMS_BANNER=R
     set GMS_SHADE=R
     set GMS_DESKTOP=R
   REM Fill character:
     set GMS_LETTER=R 
   REM Menu animation:
     set GMS_ANIMATE=on
     if "%OS%" == "" set GMS_ANIMATE=off
     if "%OS%" == "Windows_9x" set GMS_ANIMATE=off

 REM Programs: ----------------------------------------------------------------

 set GMS_VIEWER=viewer
 set GMS_ANALYST=tidy 
 set GMS_TSETTER=pdfetex
 
 if "%OS%" == "" set GMS_EDITOR=editor
 if "%OS%" == "" if not "%DRDOSCFG%" == "" set GMS_EDITOR=edit
 if not "%OS%" == "" set GMS_EDITOR=notepad
 
 if not "%OS%" == "" set GMS_BROWSER=default
 if "%OS%" == "" set GMS_BROWSER=browser
 if "%OS%" == "Windows_9x" set GMS_BROWSER=browser 
 
 if not "%OS%" == "" set GMS_READER=default
 if "%OS%" == "Windows_9x" set GMS_READER=reader
 if "%OS%" == "" set GMS_READER=reader

 REM Launcher sript: ==========================================================

 REM Create a new "gerolf" script:
 echo.
 echo  Building:     GMS launcher script ...
 echo                  %GMS_SETTING%\gerolf.bat
 call g_dos -current_cp
 call g_launch -build called_by gmssetup
 if "%OS%" == "" if exist %GMS_SETTING%\gerolf.bat goto fi_cg
 if not "%OS%" == "" if exist "%GMS_SETTING%\gerolf.bat" goto fi_cg
   echo  Error:        Could not build launcher script.
   goto tixe
 :fi_cg

 REM Show lower desktop border: -----------------------------------------------

 set REPLY_BANNER=0
 set REPLY_TEXT=7
 set REPLY_OFFSET=0
 set REPLY_SIZE=82
 set   arg=///////////////////////////////////////
 if "%OS%" == "Windows_9x" set arg=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 if "%winbootdir%" == "." set arg=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
   reply -banner 23 "%arg%%arg%"
 if "%OS%" == "" set arg=DOS
 if "%OS%" == "" if not "%windir%" == "" set arg=Windows_3x
 if not "%OS%" == "" set arg=%OS%
 if not "%GMS_FreeDOS%" == "" set arg=FreeDOS (www.freedos.org)
 if not "%GMS_DRDOS%" == "" set arg=DRDOS Version %GMS_DRDOS%x
   echo  Running under %arg% ...
 set arg=
 set REPLY_OFFSET=79
 set REPLY_SIZE=3
 reply -banner 10 " "
 
 REM Get a system directory that can be supposed to be included in search path:
 REM --------------------------------------------------------------------------
 
 if not "%windir%" == "" goto fi_ss
   set windir=%GMS_DRIVE%
   if exist %TEMP%\%any% set windir=%TEMP%
   if "%GMS_FreeDOS%" == "" goto fi_sfd
     if exist %GMS_DRIVE%\fdos\%any% set windir=%GMS_DRIVE%\fdos
     if exist %GMS_DRIVE%\fdos\bin\%any% set windir=%GMS_DRIVE%\fdos\bin
     if exist %GMS_DRIVE%\freedos\%any% set windir=%GMS_DRIVE%\freedos
     if exist C:\fdos\%any% set windir=C:\fdos
     if exist C:\fdos\bin\%any% set windir=C:\fdos\bin
     if exist C:\freedos\%any% set windir=C:\freedos
     goto fi_s
   :fi_sfd
   if "%GMS_DRDOS%" == "" goto fi_sdr
     if exist %GMS_DRIVE%\drdos\*.* set windir=%GMS_DRIVE%\drdos
     if exist %GMS_DRIVE%\drdos5\*.* set windir=%GMS_DRIVE%\drdos5
     if exist %GMS_DRIVE%\drdos50\*.* set windir=%GMS_DRIVE%\drdos50
     if exist %GMS_DRIVE%\drdos6\*.* set windir=%GMS_DRIVE%\drdos6
     if exist %GMS_DRIVE%\drdos60\*.* set windir=%GMS_DRIVE%\drdos60
     if exist C:\drdos\*.* set windir=C:\drdos
     if exist C:\drdos5\*.* set windir=C:\drdos5
     if exist C:\drdos50\*.* set windir=C:\drdos50
     if exist C:\drdos6\*.* set windir=C:\drdos6
     if exist C:\drdos60\*.* set windir=C:\drdos60
     if "%DRDOSCFG%" == "" goto fi_s
       if exist %GMS_DRIVE%\drdos7\%any% set windir=%GMS_DRIVE%\drdos7
       if exist %GMS_DRIVE%\drdos70\%any% set windir=%GMS_DRIVE%\drdos70
       if exist %GMS_DRIVE%\drdos701\%any% set windir=%GMS_DRIVE%\drdos701
       if exist %GMS_DRIVE%\drdos702\%any% set windir=%GMS_DRIVE%\drdos702
       if exist %GMS_DRIVE%\drdos703\%any% set windir=%GMS_DRIVE%\drdos703
       if exist C:\drdos7\%any% set windir=C:\drdos7
       if exist C:\drdos70\%any% set windir=C:\drdos70
       if exist C:\drdos701\%any% set windir=C:\drdos701
       if exist C:\drdos702\%any% set windir=C:\drdos702
       if exist C:\drdos703\%any% set windir=C:\drdos703
     goto fi_s
   :fi_sdr
   if exist %GMS_DRIVE%\dos\%any% set windir=%GMS_DRIVE%\dos
   if exist %GMS_DRIVE%\dos5\%any% set windir=%GMS_DRIVE%\dos5
   if exist %GMS_DRIVE%\dos50\%any% set windir=%GMS_DRIVE%\dos50
   if exist %GMS_DRIVE%\dos6\%any% set windir=%GMS_DRIVE%\dos6
   if exist %GMS_DRIVE%\dos60\%any% set windir=%GMS_DRIVE%\dos60
   if exist %GMS_DRIVE%\dos61\%any% set windir=%GMS_DRIVE%\dos61
   if exist %GMS_DRIVE%\dos62\%any% set windir=%GMS_DRIVE%\dos62
   if exist %GMS_DRIVE%\dos7\%any% set windir=%GMS_DRIVE%\dos7
   if exist %GMS_DRIVE%\dos70\%any% set windir=%GMS_DRIVE%\dos70
   if exist %GMS_DRIVE%\dos71\%any% set windir=%GMS_DRIVE%\dos71
   if exist %GMS_DRIVE%\dos72\%any% set windir=%GMS_DRIVE%\dos72
   if exist %GMS_DRIVE%\msdos\%any% set windir=%GMS_DRIVE%\msdos
   if exist %GMS_DRIVE%\ms-dos\%any% set windir=%GMS_DRIVE%\ms-dos
   if exist %GMS_DRIVE%\msdos5\%any% set windir=%GMS_DRIVE%\msdos5
   if exist %GMS_DRIVE%\msdos50\%any% set windir=%GMS_DRIVE%\msdos50
   if exist %GMS_DRIVE%\msdos6\%any% set windir=%GMS_DRIVE%\msdos6
   if exist %GMS_DRIVE%\msdos60\%any% set windir=%GMS_DRIVE%\msdos60
   if exist %GMS_DRIVE%\msdos61\%any% set windir=%GMS_DRIVE%\msdos61
   if exist %GMS_DRIVE%\msdos62\%any% set windir=%GMS_DRIVE%\msdos62
   if exist %GMS_DRIVE%\msdos7\%any% set windir=%GMS_DRIVE%\msdos7
   if exist %GMS_DRIVE%\msdos70\%any% set windir=%GMS_DRIVE%\msdos70
   if exist %GMS_DRIVE%\msdos71\%any% set windir=%GMS_DRIVE%\msdos71
   if exist %GMS_DRIVE%\msdos72\%any% set windir=%GMS_DRIVE%\msdos72
   if exist %GMS_DRIVE%\pcdos\%any% set windir=%GMS_DRIVE%\pcdos
   if exist %GMS_DRIVE%\mswin\%any% set windir=%GMS_DRIVE%\mswin
   if exist %GMS_DRIVE%\mswin3\%any% set windir=%GMS_DRIVE%\mswin3
   if exist %GMS_DRIVE%\mswin31\%any% set windir=%GMS_DRIVE%\mswin31
   if exist %GMS_DRIVE%\mswin311\%any% set windir=%GMS_DRIVE%\mswin311
   if exist %GMS_DRIVE%\win\%any% set windir=%GMS_DRIVE%\win
   if exist %GMS_DRIVE%\win3\%any% set windir=%GMS_DRIVE%\win3
   if exist %GMS_DRIVE%\win31\%any% set windir=%GMS_DRIVE%\win31
   if exist %GMS_DRIVE%\win311\%any% set windir=%GMS_DRIVE%\win311
   if exist %GMS_DRIVE%\windows\%any% set windir=%GMS_DRIVE%\windows
   if exist C:\dos\%any% set windir=C:\dos
   if exist C:\dos5\%any% set windir=C:\dos5
   if exist C:\dos50\%any% set windir=C:\dos50
   if exist C:\dos6\%any% set windir=C:\dos6
   if exist C:\dos60\%any% set windir=C:\dos60
   if exist C:\dos61\%any% set windir=C:\dos61
   if exist C:\dos62\%any% set windir=C:\dos62
   if exist C:\dos7\%any% set windir=C:\dos7
   if exist C:\dos70\%any% set windir=C:\dos70
   if exist C:\dos71\%any% set windir=C:\dos71
   if exist C:\dos72\%any% set windir=C:\dos72
   if exist C:\msdos\%any% set windir=C:\msdos
   if exist C:\ms-dos\%any% set windir=C:\ms-dos
   if exist C:\msdos5\%any% set windir=C:\msdos5
   if exist C:\msdos50\%any% set windir=C:\msdos50
   if exist C:\msdos6\%any% set windir=C:\msdos6
   if exist C:\msdos60\%any% set windir=C:\msdos60
   if exist C:\msdos61\%any% set windir=C:\msdos61
   if exist C:\msdos62\%any% set windir=C:\msdos62
   if exist C:\msdos7\%any% set windir=C:\msdos7
   if exist C:\msdos70\%any% set windir=C:\msdos70
   if exist C:\msdos71\%any% set windir=C:\msdos71
   if exist C:\msdos72\%any% set windir=C:\msdos72
   if exist C:\pcdos\%any% set windir=C:\pcdos
   if exist C:\mswin\%any% set windir=C:\mswin
   if exist C:\mswin3\%any% set windir=C:\mswin3
   if exist C:\mswin31\%any% set windir=C:\mswin31
   if exist C:\mswin311\%any% set windir=C:\mswin311
   if exist C:\win\%any% set windir=C:\win
   if exist C:\win3\%any% set windir=C:\win3
   if exist C:\win31\%any% set windir=C:\win31
   if exist C:\win311\%any% set windir=C:\win311
   if exist C:\windows\%any% set windir=C:\windows
   if not "%OS%" == "" echo   windir=%windir%>> %Z%
 :fi_s

 REM if not %windir% == C: goto fi_ss
 if not %windir% == %GMS_DRIVE% goto fi_ss
   set i=%GMS_DRIVE%\gerolf.bat
   set j=%GMS_DRIVE%\gms.bat
   set k=%GMS_DRIVE%
   echo                Could not find binary folder %k%\dos or %k%\windows.
   echo                Please link or copy %i% and %j% to a 
   echo                folder which is included in the executables search path!
   set i=
   set j=
   set k=
 :fi_ss
 
 REM Create desktop link (Windows): -------------------------------------------
 
 echo  Linking:      gerolf.bat and gms.bat to ...   
 if "%OS%" == "" goto fi_nodl 
 if "%GMS_LINKDIR%" == "" goto fi_nodl
 if not exist "%GMS_LINKDIR%\%any%" goto fi_nodl
   set gerolf="%GMS_LINKDIR%\gerolf.bat"
   if not "%GMS_DRDOS%" == "" echo echo off > %gerolf%
   if not "%GMS_DRDOS%" == "" echo cls >> %gerolf%
   if "%GMS_DRDOS%" == "" echo @echo off > %gerolf%
   echo.>> %gerolf%
   echo REM gerolf.bat Link script to Gerolf Markup Shredder>>%gerolf%
   echo REM ==========>> %gerolf%
   echo.>> %gerolf%
   rem echo %GMS_DRIVE% >> %gerolf%
   if "%OS%" == "" echo call %GMS_SETTING%\gerolf %%1 %%2 %%3 %%4>> %gerolf%
 if not "%OS%" == "" echo call "%GMS_SETTING%\gerolf" %%1 %%2 %%3 %%4>>%gerolf% 
 :fi_nodl   
 
 REM Context Menu and Start Menu: ---------------------------------------------
          
 if "%OS%" == "" goto fi_noos
   if "%GMS_SENDDIR%" == "" goto fi_nosd
   if not exist "%GMS_SENDDIR%\%any%" goto fi_nosd
     copy %gerolf% "%GMS_SENDDIR%" > nul
   :fi_nosd
   if "%GMS_MENUDIR%" == "" goto fi_nomd2
   if not exist "%GMS_MENUDIR%\%any%" goto fi_nomd2 
   if exist "%GMS_MENUDIR%\Markup Shredder\%any%" goto fi_nomd1
     md "%GMS_MENUDIR%\Markup Shredder" > nul
   :fi_nomd1
     copy %gerolf% "%GMS_MENUDIR%\Markup Shredder" > nul
   :fi_nomd2
 :fi_noos
 
 REM Copy 'sort.exe' to binary folder on Windows 9x: -------------------------- 
 
 if not "%OS%" == "Windows_9x" goto fi_sort
   if exist "%GMS_BINARIES%\sort.exe" goto fi_sort
     copy "%windir%\command\sort.exe" "%GMS_BINARIES%" > nul
 :fi_sort
      
 REM Writing link scripts to system directory: --------------------------------
 
 echo                  %windir%
 REM set gerolf=%windir%\gerolf.bat 
 set gerolf=..\gerolf.bat

 if not "%GMS_DRDOS%" == "" echo echo off > %gerolf%
 if not "%GMS_DRDOS%" == "" echo cls >> %gerolf%
 if "%GMS_DRDOS%" == "" echo @echo off > %gerolf%
 echo.>> %gerolf%
 echo REM gerolf.bat Link script to Gerolf Markup Shredder>>%gerolf%
 echo REM ========== Must be placed in search path>> %gerolf%
 echo.>> %gerolf% 
 if "%OS%" == "" echo call %GMS_SETTING%\gerolf %%1 %%2 %%3 %%4>> %gerolf%
 if not "%OS%" == "" echo call "%GMS_SETTING%\gerolf" %%1 %%2 %%3 %%4>>%gerolf%
 
 if "%OS%" == "" copy %gerolf% %windir% > nul
 if "%OS%" == "" goto fi_xp1
 if "%OS%" == "Windows_9x" copy %gerolf% %windir% > nul
 if "%OS%" == "Windows_9x" goto fi_xp1 
   copy "%gerolf%" "%windir%" > nul 2> nul
 :fi_xp1
 set gerolf=

 REM set gms=%windir%\gms.bat
 set gms=..\gms.bat

 if not "%GMS_DRDOS%" == "" echo echo off > %gms%
 if not "%GMS_DRDOS%" == "" echo cls >> %gms%
 if "%GMS_DRDOS%" == "" echo @echo off > %gms%
 echo.>> %gms%
 echo REM gms.bat Link script to Gerolf Markup Shredder>> %gms%
 echo REM ======= Must be placed in search path>> %gms%
 echo.>> %gms%
 if "%OS%" == "" echo call %GMS_BATCH%\gms %%1 %%2 %%3 %%4 %%5 %%6>> %gms%
 if not "%OS%" == "" echo call "%GMS_BATCH%\gms" %%1 %%2 %%3 %%4 %%5 %%6>>%gms%
 
 if "%OS%" == "" copy %gms% %windir% > nul
 if "%OS%" == "" goto fi_xp2
 if "%OS%" == "Windows_9x" copy %gms% %windir% > nul
 if "%OS%" == "Windows_9x" goto fi_xp2 
   if not "%OS%" == "" copy "%gms%" "%windir%" > nul 2> nul
 :fi_xp2
 set gms=

 REM Check if links have been created: ----------------------------------------

 if "%OS%" == "" if exist %windir%\gerolf.bat goto fi_nl1
 if not "%OS%" == "" if exist "%windir%\gerolf.bat" goto fi_nl1
   echo.
   echo                Could not build link from
   echo                %GMS_SETTING%\gerolf.bat to
   echo                  %windir%
   echo                Link or copy gerolf.bat into the search path.
 :fi_nl1

 if "%OS%" == "" if exist %windir%\gms.bat goto fi_nl2
 if not "%OS%" == "" if exist "%windir%\gms.bat" goto fi_nl2
   echo.
   echo                Could not build link from
   echo                %GMS_BATCH%\gms.bat to
   echo                  %windir%
   echo                Link or copy gms.bat into the search path.
 :fi_nl2
   
 REM Create desktop link for quick setup (Windows): ---------------------------
 
 if "%OS%" == "" goto fi_nolnk  
 if "%GMS_LINKDIR%" == "" goto fi_nolnk
      
   REM Writing test:
     if not "%OS%" == "Windows_9x" goto else_x1
       echo GMS writing test (2).> "%GMS_LINKDIR%\gms.002"
       echo This file can be removed.>> "%GMS_LINKDIR%\gms.002"
       goto fi_x1
     :else_x1
       echo GMS writing test (2).> "%GMS_LINKDIR%\gms.002" 2> nul
       echo This file can be removed.>> "%GMS_LINKDIR%\gms.002" 2> nul
     :fi_x1
     if exist "%GMS_LINKDIR%\gms.002" goto fi_notxt
       echo                Cannot write start links to
       echo                %GMS_LINKDIR%.
       echo.
       if not "%OS%" == "Windows_NT" if not "%OS%" == "Windows_XP" goto fi_x2
         echo                Please log in as administrator to install GMS.
         goto tixe
       :fi_x2
       echo                Press any key to continue or [Ctrl+C] to break ...
       pause > nul
       goto fi_nowin
     :fi_notxt
     if exist "%GMS_LINKDIR%\gms.002" del "%GMS_LINKDIR%\gms.002"       
   :fi_nowin
     
 REM Recreate desktop link for setup (Windows): -------------------------------
 
   set GMS_LINK=..\gmssetup.bat
     if not "%GMS_DRDOS%" == "" echo echo off > %GMS_LINK%
     if not "%GMS_DRDOS%" == "" echo cls >> %GMS_LINK%
     if "%GMS_DRDOS%" == "" echo @echo off > %GMS_LINK%
     echo.>> %GMS_LINK%
     echo REM gmssetup.bat Link script to:>> %GMS_LINK%
     echo REM ============ Gerolf Markup Shredder setup>> %GMS_LINK%
     echo.>> %GMS_LINK%
     echo %GMS_DRIVE%>> %GMS_LINK%
     echo cd "%GMS_SETTING%" >> %GMS_LINK%
     echo "%GMS_SETTING%\gmssetup.bat" %%1>> %GMS_LINK%
   copy "%GMS_LINK%" "%GMS_LINKDIR%" > nul   
   if not exist "%GMS_MENUDIR%\%any%" goto fi_nosm3
     copy %GMS_LINK% "%GMS_MENUDIR%\Markup Shredder" > nul
   :fi_nosm3
   set GMS_LINK=
   set GMS_LINKDIR=
   set GMS_MENUDIR=
 :fi_nolnk
   
 REM Batch compiling, font map and format creation: ===========================

 REM Batch compiling:
 echo.
 if "%OS%" == "" if exist %GMS_BATCH%\%any% cd %GMS_BATCH%
 if not "%OS%" == "" if exist "%GMS_BATCH%\%any%" cd "%GMS_BATCH%"
 if "%GMS_DRDOS%" == "6" echo.
 if "%GMS_DRDOS%" == "6" echo.
 if "%GMS_DRDOS%" == "6" goto fi_bccc
   echo  Compiling:    batch command scripts ...
   call compiler -quiet called_by gmssetup
 if "%OS%" == "" goto fi_bcc
   echo   see '%GMS_BATCH%\compiler.log' for syntax check results>> %Z%
 :fi_bcc
   echo                  %GMS_BATCH%\l_*.bat to l_*.com
 :fi_bccc
 set GMS_FOLDER=%GMS_SETTING%
 if "%OS%" == "" if exist %GMS_FOLDER%\%any% cd %GMS_FOLDER%
 if not "%OS%" == "" if exist "%GMS_FOLDER%\%any%" cd "%GMS_FOLDER%"

 REM Copy Windows true type fonts: --------------------------------------------
  
 if "%OS%" == "" goto fi_nofnt 
   echo.
   echo  Copying:      *.ttf - True Type Fonts from/to %windir%\Fonts ...
   call g_font -exchange_fonts called_by gmssetup
 :fi_nofnt
 
 if not "%OS%" == "" goto fi_nofnw 
   if not exist c:\windows\system\*.ttf goto fi_nofnw
   copy c:\windows\system\*.ttf %GMS_FONTS%\ttf > nul 
 :fi_nofnw
  
 REM Write font map (if not in quick mode): -----------------------------------
 
 if "%1" == "--quick" goto fi_nomap
 if "%1" == "-quick" goto fi_nomap
 if "%1" == "/quick" goto fi_nomap
 if "%1" == "quick" goto fi_nomap
 if "%1" == "--QUICK" goto fi_nomap
 if "%1" == "-QUICK" goto fi_nomap
 if "%1" == "/QUICK" goto fi_nomap
 if "%1" == "QUICK" goto fi_nomap
   call gms -shell -w -quiet called_by gmssetup
 :fi_nomap

 set REPLY_OFFSET=0
 set REPLY_SIZE=82
 reply -banner 22
 reply -banner 21
 reply -banner 20
 reply -banner 19
 
 REM Check if pool file has appropriate name: ---------------------------------
 
 if not "%OS%" == "" goto fipool0
 if "%OS%" == "" if not exist %GMS_BINARIES%\pdfetex.poo goto fipool0
   ren %GMS_BINARIES%\pdfetex.poo pdfetex.tmp
   ren %GMS_BINARIES%\pdfetex.tmp pdfetex.pool 
 :fipool0 
 
 if "%OS%" == "" if exist %GMS_BINARIES%\pdfetex.po* goto fipool2
 if not "%OS%" == "" if not exist "%GMS_BINARIES%\pdfete~1.po*" goto fipool1
   if "%OS%" == "" ren %GMS_BINARIES%\pdfete~1.po* pdfetex.poo
   if not "%OS%" == "" ren "%GMS_BINARIES%\pdfete~1.po*" pdfetex.pool
 :fipool1 
 if "%OS%" == "" if exist %GMS_BINARIES%\pdfetex.po* goto fipool2
 if not "%OS%" == "" if exist "%GMS_BINARIES%\pdfetex.po*" goto fipool2
   echo  Error:        No message string file '%GMS_BINARIES%\pdfetex.po*'.
   pause > nul
 :fipool2
 
 if "%OS%" == "" goto fipool3
 if exist "%GMS_BINARIES%\pdfetex.pool" goto fipool3
 if exist "%GMS_BINARIES%\pdfetex.poo" goto elspoo3
 if exist "%GMS_BINARIES%\pdfete~1.poo" goto elspol3
   echo  Error:        No message string file '%GMS_BINARIES%\pdfetex.pool'.
   goto fipool3
 :elspoo3
   ren "%GMS_BINARIES%\pdfetex.poo" pdfetex.pool
   goto fipool3
 :elspol3
   ren "%GMS_BINARIES%\pdfete~1.poo" pdfetex.pool
 :fipool3 

 REM Check if DLL required by Tidy is missing on Windows-95: ------------------

 if not "%OS%" == "Windows_9x" goto fi_dll
 if exist "%windir%\system\msvcrt.dll" goto fi_dll
 if not exist "%windir%\system\msvcrt40.dll" goto fi_dll
   copy "%windir%\system\msvcrt40.dll" "%windir%\system\msvcrt.dll" > nul
 :fi_dll

 REM Define maximal number of input files on Dos: -----------------------------

 if not "%OS%" == "" goto fifiles
   set arg=%GMS_SETTING%\files.cfg
   echo. > %arg%
   echo  %% files.cfg>> %arg%
   echo  %% =========>> %arg%
   echo.>> %arg%
   echo  %% This file defines the maximal number of input>> %arg%
   echo  %% files for Gerolf Markup Shredder on Dos.>> %arg%
   echo.>> %arg%
   echo  \message {-}>> %arg%
   echo.>> %arg%
   echo  \def \NOfilemax {222}>> %arg%
   echo.>> %arg%
   echo  \message {Maximal number of input or image files: \NOfilemax}>> %arg%
   echo.>> %arg%
   echo  \endinput>> %arg%
 :fifiles
 
 REM Initialize format: -------------------------------------------------------
  
 set REPLY_OFFSET=0
 set REPLY_SIZE=17
 reply -banner 18 Initializing:
 set REPLY_OFFSET=14
 set REPLY_SIZE=68 
 reply -banner 18 "TeX format file (this may take some time) ..."
 if "%GMS_DRDOS%" == "" call gms -shell -i -quiet called_by gmssetup > nul
 if not "%GMS_DRDOS%" == "" call gms -shell -i -quiet called_by gmssetup
 set REPLY_BANNER=0
 set REPLY_TEXT=7
 set REPLY_OFFSET=14
 set REPLY_SIZE=68
 if "%OS%" == "" reply -banner 18 "  %GMS_BINARIES%\gerolf.(efm/fmt)"
 if not "%OS%" == "" reply -banner 18 "  %GMS_BINARIES%\gerolf.(e)fmt"
 
 REM Write memo (load default.htm): -------------------------------------------

 set GMS_FOLDER=%GMS_TEMPLATE%\default
 set GMS_FILE=default.htm
 call g_vars -write_memo called_by gmssetup
 
 REM Goodbye message: =========================================================

 echo.
 echo  Startup call: gerolf ... textmode interface (random colors)
 echo.
 echo.
 set arg=///////////////////////////////////////
 if "%OS%" == "Windows_9x" set arg=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 if "%winbootdir%" == "." set arg=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
   echo  %arg%%arg%
 set arg=

 :exit 
   set GMS_FOLDER=%GMS_SETTING%
   REM Fixme for spacy names:
   if "%OS%" == "" if exist %GMS_FOLDER%\%any% cd %GMS_FOLDER%
   if not "%OS%" == "" if exist "%GMS_FOLDER%\%any%" cd "%GMS_FOLDER%"
   REM Draw startup/break info on screen:
     set arg=        Press any key to start or [Ctrl+C] to quit
       echo  Done:         GMS setup.    %arg%
     set arg=
   REM Draw gms startup info on screen:
     set REPLY_OFFSET=14
     set REPLY_SIZE=68
       reply -banner 21 "gms ... command line interface (black/white)"
   REM Set break cursor at a nice place:
     set REPLY_OFFSET=13
     set REPLY_SIZE=0
       reply -banner 22 
   REM Clean up environment:
     call g_vars -clear called_by gmssetup
   REM Rename gmsdebug.log to gmssetup.log:
     if not "%OS%" == "" if exist %Z% if exist gmssetup.log del gmssetup.log
     if not "%OS%" == "" if exist %Z% ren %Z% gmssetup.log
   REM Write gmsdebug.log footer:
     if "%OS%" == "" goto fi_noft
       set arg=////////////////////////////////////////
      if "%OS%" == "Windows_9x" set arg=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
       if "%winbootdir%" == "." set arg=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
         echo %arg%%arg%>> %Z%
         echo. %GMS_SETTING%>> %Z%
       set arg=
     :fi_noft
   REM First Steps readme: ....................................................
 REM pause > nul
 REM cls
 REM if  "%OS%" == "DRDOS" set GMS_DRDOS=6
 REM if not "%DRDOCFGS%" == "" set GMS_DRDOS=7
 REM if  "%OS%" == "DRDOS" set OS=
 REM type readme.txt
   REM Allow user interruption or start textmode interface:
     if "%OS%" == "" goto fi_w
     if "%OS%" == "Windows_9x" goto fi_w
       set argw=Welcome to Gerolf Markup Shredder
       if not "%OS%" == "" title %argw% - www.Gerolf.org > nul
       set argw=
     :fi_w
   REM Final unsets: ..........................................................
     set Z=
     set GMS_DEBUG=
     set GMS_INST=
     set GMS_MISS=
     set GMS_SETTING=
     set GMS_SENDDIR=
     pause > nul
     if not "%OS%" == "" if not "%OS%" == "Windows_9x" color 07
     gerolf called_by gmssetup
 :tixe
 echo.
