 REM folder.bat 
 REM ==========
 
 REM Folder structure file for Gerolf Markup Shredder (Dos/Windows)
 
 REM Entries with a leading "REM" mark  are disabled  for the command line  and
 REM text mode interfaces of GMS only.  The browser interface parses this file,
 REM it does not execute it  as a batch script. So  the "commented out" entries
 REM must be set correctly for the browser interface,  and it is not allowed to
 REM use variables other than  GMS_ROOT  and  SRV_ROOT  in it, if the directory 
 REM names are not given absolutely (see "setting.pm"). Other variables are not
 REM recognized by the browser interface parser.   
 
 REM ==========================================================================
 
 REM CAUTION: NO WHITESPACE is allowed to follow values assigned to variables!
 
 REM 1) GMS directories:
 
 REM Server subdirectories:
   REM set GMS_ROOT_SHORT=
   REM set SRV_ROOT=
 
 REM Shell scripts (Dos): 
   set GMS_BATCH=%GMS_ROOT%\batch
 
 REM Temporary files:
   set GMS_TEMP=%GMS_DRIVE%\tmp
     REM If the temporary files folder is not on top level of the tree, you may
     REM have to create it manually before running gmssetup. 
   REM Temporary files can be written to a RAM drive on Dos:
     REM set GMS_TEMP=R:
     REM In order to do that, an entry like this is required in c:\config.sys:
     REM device=c:\dos\ramdrive.sys 16
 
 REM Template markup files:
   set GMS_TEMPLATE=%GMS_ROOT%\doc
   REM Fixme: Should be possible to move the template folder to %USERPROFILE%
    
 REM Encoding: 
   REM set SRV_ENCODING=%SRV_ROOT%\data\enc
 
 REM Handbook: 
   REM set SRV_HANDBOOK=%SRV_ROOT%\doc\handbook
  
 REM Language strings:
   REM set GMS_LANGUAGE=%GMS_ROOT%\data\lang
 
 REM Process (must be writable for any user):
   REM set GMS_PROCESS=%GMS_ROOT%\tmp
   REM set SRV_PROCESS=%SRV_ROOT%\tmp
 
 REM Rotation of banners:
   REM set GMS_ROTATION=%GMS_ROOT%\doc\rotation
 
 REM Setting:
   REM set SRV_SETTING=%SRV_ROOT%\etc
 
 REM Style:
   REM set SRV_STYLE=%SRV_ROOT%\data\css
  
 REM 2) Directories for TeX engine configuration: -----------------------------
 
 REM ; path separator
 REM \ directory separator
 REM \\ subdirectory inclusion
 
 REM TeX Main Folder:
   set TEXMF=%GMS_ROOT%
 
 REM Configuration files texmf.cnf and pdftex.cfg:
   set TEXMFCNF=%GMS_ROOT%\etc
 
 REM Binaries: 
   if "%OS%" == "" set GMS_BINARIES=dos
   if "%windir%" == "" set GMS_BINARIES=dos
   if not "%OS%" == "" if not "%windir%" == "" set GMS_BINARIES=win
   if "%GMS_DOSMODE%" == "1" set GMS_BINARIES=dos
   set GMS_BINARIES=%GMS_ROOT%\bin\%GMS_BINARIES%
 
 REM Directory to place .log files, if current directory is read-only:
   set TEXMFOUTPUT=%GMS_ROOT%\tmp
 
 REM Dump files (.fmt/.efmt on Windows, .fmt/.efm on Dos) for virtex:
   set TEXFORMATS=%GMS_BINARIES%
 
 REM String pools (.pool on Windows, .poo on Dos) for initex:
   set TEXPOOL=%GMS_BINARIES%
 
 REM 3) TeX input file search:-------------------------------------------------
 
 REM This must be one single directory:
   set TEX_USER=%GMS_ROOT%\doc
 
 REM This is needed only during initex run (single directory): 
   set TEX_BASE=%GMS_ROOT%\tex

 REM Encodings (.enc), PostScript fonts, font maps):
   set TEXPSHEADERS=%GMS_ROOT%\etc
   set TEXPSHEADERS=%TEXPSHEADERS%;%GMS_ROOT%\data\enc
   set TEXPSHEADERS=%TEXPSHEADERS%;%GMS_ROOT%\fonts\\
 
 REM 4) TeX font search: ------------------------------------------------------
 
 REM This is needed only during initex run (single directory): 
   set GMS_FONTS=%GMS_ROOT%\fonts
   
   REM TeX font metric files:
     set TEXFONTS=%GMS_FONTS%\tfm\\
    
   REM TeX virtual fonts:
     set VFFONTS=%GMS_FONTS%\vf\\
 
   REM PostScript Adobe metric files:
     set AFMFONTS=%GMS_FONTS%\afm\\
 
   REM PostScript Type 1 outline fonts:
     set T1FONTS=%GMS_FONTS%\type1\\
 
   REM TrueType outline fonts:
     set TTFONTS=%GMS_FONTS%\ttf\\
 
 REM 5) Contribute to gmsdebug.log: -------------------------------------------

 if "%OS%" == "" goto exit 
   if not %Z% == "" echo %0 (%1) (%2) (%3) (%4) (%5) (%6) (%7) (%8)>> %Z%
 :exit
