 REM l_rain.bat
 REM ==========

 REM This file is part of Gerolf Markup Shredder,
 REM written by G. D. Brettschneider (1999-2006).

 REM set GMSdateL_RAIN=20060927

 REM Prologue: ================================================================

 REM Not running:

 if not "%GMS_BATCH%" == "" goto fi_nr
   echo  G e r o l f   M a r k u p   S h r e d d e r   (l_rain) . . .
   pause > nul
   gerolf 2> nul
   goto exit
 :fi_nr

 REM Debug: -------------------------------------------------------------------

 if "%OS%" == "" goto fi_db
 if -%GMS_DEBUG% == - goto fi_db
 REM if %GMS_DEBUG% == Z echo %0 (%1) (%2) (%3) (%4) (%5) (%6) (%7) (%8)>> %Z%
 if %GMS_DEBUG% == X goto then_db
 if not %GMS_DEBUG% == Y goto fi_db
 :then_db
   call l_banner -debug l_rain %1 %2 %3 %4
 :fi_db

 REM Chapters: ================================================================

 REM Not defined:

 if not "%1" == "" goto fi_nd
   call l_banner -no_action l_rain
   goto exit
 :fi_nd

 REM Rainbow column: ----------------------------------------------------------

 if not %1 == -raincol goto fi_rc
   set REPLY_SIZE=1
   set REPLY_DESKTOP=%2
 REM Get offset and letter number:
   set REPLY_OFFSET=%2
   if %2 == 0 set REPLY_OFFSET=6
   if %2 == 0 set LETTER=48
   if %2 == 1 set REPLY_OFFSET=7
   if %2 == 1 set LETTER=49
   if %2 == 2 set REPLY_OFFSET=8
   if %2 == 2 set LETTER=50
   if %2 == 3 set REPLY_OFFSET=9
   if %2 == 3 set LETTER=51
   if %2 == 4 set REPLY_OFFSET=10
   if %2 == 4 set LETTER=52
   if %2 == 5 set REPLY_OFFSET=11
   if %2 == 5 set LETTER=53
   if %2 == 6 set REPLY_OFFSET=12
   if %2 == 6 set LETTER=54
   if %2 == 7 set REPLY_OFFSET=13
   if %2 == 7 set LETTER=55
 REM Draw column:
   reply -stripe 5 0 %LETTER%
   reply -stripe 6 1 %LETTER%
   reply -stripe 7 2 %LETTER%
   reply -stripe 8 3 %LETTER%
   reply -stripe 9 4 %LETTER%
   reply -stripe 10 5 %LETTER%
   reply -stripe 11 6 %LETTER%
   reply -stripe 12 7 %LETTER%
   reply -stripe 13 8 %LETTER%
   reply -stripe 14 9 %LETTER%
   reply -stripe 15 10 %LETTER%
   reply -stripe 16 11 %LETTER%
   reply -stripe 17 12 %LETTER%
   reply -stripe 18 13 %LETTER%
   reply -stripe 19 14 %LETTER%
   reply -stripe 20 15 %LETTER%
   set LETTER=
   goto exit
 :fi_rc

 REM Rainbow: -----------------------------------------------------------------

 if not %1 == -build goto fi_b
 REM Save colors:
   set BACKUP1=%REPLY_DESKTOP%
   set BACKUP2=%REPLY_PATTERN%
   set BACKUP3=%REPLY_BANNER%
   set BACKUP4=%REPLY_TEXT%
 REM Clear desktop area for pane:
   for %%i in (12 13 11 14 10 15) do reply -stripe %%i 0 32
   for %%i in ( 9 16 8 17 7 18) do reply -stripe %%i 0 32
   for %%i in ( 6 19 5 20 4 21) do reply -stripe %%i 0 32
   for %%i in ( 3 22 ) do reply -stripe %%i 0 32
 REM Draw heading:
   set REPLY_BANNER=%BACKUP1%
   set REPLY_TEXT=%REPLY_HOTKEY%
   reply -banner 3 "   Back- & Fore- " 
   reply -banner 22 "  -ground colors " 
 REM Draw columns with background color numbers:
   for %%i in ( 0 1 2 3) do call l_rain -raincol %%i
   for %%i in ( 4 5 6 7) do call l_rain -raincol %%i
 REM Clear overwritten area:
   set REPLY_OFFSET=14
   set REPLY_SIZE=5
   set REPLY_DESKTOP=%BACKUP1%
   set REPLY_PATTERN=%BACKUP2%
   for %%i in ( 5 6 7 8 9 10) do reply -stripe %%i 0 32
   for %%i in (11 12 13 14 15 16) do reply -stripe %%i 0 32
   for %%i in (17 18 19 20 ) do reply -stripe %%i 0 32
 REM Draw rows with foreground color numbers:
   set REPLY_BANNER=%REPLY_DESKTOP%
   set REPLY_SIZE=3
 REM One digit:
   set REPLY_OFFSET=18
   set REPLY_TEXT=0
   reply -banner 5 0 
   set REPLY_TEXT=1
   reply -banner 6 1 
   set REPLY_TEXT=2
   reply -banner 7 2 
   set REPLY_TEXT=3
   reply -banner 8 3 
   set REPLY_TEXT=4
   reply -banner 9 4 
   set REPLY_TEXT=5
   reply -banner 10 5 
   set REPLY_TEXT=6
   reply -banner 11 6 
   set REPLY_TEXT=7
   reply -banner 12 7 
   set REPLY_TEXT=8
   reply -banner 13 8 
   set REPLY_TEXT=9
   reply -banner 14 9 
 REM Two digits:
   set REPLY_OFFSET=17
   set REPLY_TEXT=10
   reply -banner 15 10 
   set REPLY_TEXT=11
   reply -banner 16 11 
   set REPLY_TEXT=12
   reply -banner 17 12 
   set REPLY_TEXT=13
   reply -banner 18 13 
   set REPLY_TEXT=14
   reply -banner 19 14 
   set REPLY_TEXT=15
   reply -banner 20 15 
 REM Reset colors:
   set REPLY_BANNER=%BACKUP3%
   set REPLY_TEXT=%BACKUP4%
   set BACKUP1=
   set BACKUP2=
   set BACKUP3=
   set BACKUP4=
   goto exit
 :fi_b

 REM Rainbow (and codepage) remove: -------------------------------------------

 if not %1 == -remove goto fi_r
 REM Clear pane:
   if not %GMS_ANIMATE% == on goto fi_rr
     for %%i in (4 21 5 20) do reply -stripe %%i 0 32
     for %%i in (6 19 7 18 8 17) do reply -stripe %%i 0 32
     for %%i in (9 16 10 15 11 14) do reply -stripe %%i 0 32
     for %%i in (12 13) do reply -stripe %%i 0 32
   :fi_rr
 REM Remove pane:
   for %%i in (3 22 4) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
   for %%i in (21 5 20) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
   for %%i in (6 19 7) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
   for %%i in (18 8 17) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
   for %%i in (9 16 10) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
   for %%i in (15 11 14) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
   for %%i in (12 13) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
   goto exit
 :fi_r

 REM Not found: ---------------------------------------------------------------

 :else
   call l_banner -no_action l_rain %1 
 :fi

 :exit
