 REM l_box.bat
 REM =========

 REM This file is part of Gerolf Markup Shredder,
 REM written by G. D. Brettschneider (1999-2006).

 REM set GMSdateL_BOX=20060927

 REM Prologue: ================================================================

 REM Not running:

 if not "%GMS_BATCH%" == "" goto fi_nr
   echo  G e r o l f   M a r k u p   S h r e d d e r   (l_box)   . . .
   pause > nul
   gerolf 2> nul
   goto exit
 :fi_nr

 REM Debug: -------------------------------------------------------------------

 if "%OS%" == "" goto fi_db
 if -%GMS_DEBUG% == - goto fi_db
 REM if %GMS_DEBUG% == Z echo %0 (%1) (%2) (%3) (%4) (%5) (%6) (%7) (%8)>> %Z%
 if %GMS_DEBUG% == X goto then_db
 if not %GMS_DEBUG% == Y goto fi_db
 :then_db
   call l_banner -debug l_box %1 %2 %3 %4
 :fi_db

 REM Chapters: ================================================================

 REM Not defined:

 if not "%1" == "" goto fi_nd
   call l_banner -no_action l_box
   goto exit
 :fi_nd

 REM Idle: --------------------------------------------------------------------

 if not %1 == -idle goto fi_id
   reply -item 4 " " " " 
   goto exit
 :fi_id 

 REM Build: ===================================================================

 REM Box cycle:

 if not %1 == -cyc_build goto fi_bc
   if not %2 == 0 reply -top %2
   if not %3 == 0 reply -item %3
   if not %4 == 0 reply -shadow %4
   if not %5 == 0 reply -bottom %5
   if not %6 == 0 reply -item %6
   goto exit
 :fi_bc

 REM Box, y-offset=13: --------------------------------------------------------

 if not %1 == -build goto fi_b
   if not %GMS_ANIMATE% == on goto fi_bb
     REM                         ,- Offset
     call l_box -cyc_build 12 0 13 0 0
     call l_box -cyc_build 11 12 14 13 12
     call l_box -cyc_build 10 11 15 14 13
     call l_box -cyc_build 9 10 16 15 14
     call l_box -cyc_build 8 9 17 16 15
     call l_box -cyc_build 7 8 18 17 16
     call l_box -cyc_build 6 7 19 18 17
     call l_box -cyc_build 5 6 20 19 18
     call l_box -cyc_build 4 5 21 20 19
     call l_box -cyc_build 3 4 22 21 20
   :fi_bb
   goto exit
 :fi_b

 REM Top box, y-offset=12: ----------------------------------------------------

 if not %1 == -t12_build goto fi_b12
   if not %GMS_ANIMATE% == on goto fi_b1b
     REM                         ,- Offset
     call l_box -cyc_build 11 0 12 0 0
     call l_box -cyc_build 10 11 13 12 11
     call l_box -cyc_build 9 10 14 13 12
     call l_box -cyc_build 8 9 15 14 13
     call l_box -cyc_build 7 8 16 15 14
     call l_box -cyc_build 6 7 17 16 15
     call l_box -cyc_build 5 6 18 17 16
     call l_box -cyc_build 4 5 19 18 17 
     call l_box -cyc_build 3 4 20 19 18 
   :fi_b1b
   goto exit
 :fi_b12

 REM Top box, y-offset=11: ----------------------------------------------------

 if not %1 == -t11_build goto fi_b11
   if not %GMS_ANIMATE% == on goto fi_bab
     REM                         ,- Offset
     call l_box -cyc_build 10 0 11 0 0
     call l_box -cyc_build 9 10 12 11 10
     call l_box -cyc_build 8 9 13 12 11
     call l_box -cyc_build 7 8 14 13 12
     call l_box -cyc_build 6 7 15 14 13
     call l_box -cyc_build 5 6 16 15 14
     call l_box -cyc_build 4 5 17 16 15
     call l_box -cyc_build 3 4 18 17 16 
   :fi_bab
   goto exit
 :fi_b11

 REM Top box, y-offset=8: -----------------------------------------------------

 if not %1 == -t8_build goto fi_b8
   if not %GMS_ANIMATE% == on goto fi_b8b
     REM                       ,- Offset
     call l_box -cyc_build 7 0 8 0 0
     call l_box -cyc_build 6 7 9 8 7
     call l_box -cyc_build 5 6 10 9 8
     call l_box -cyc_build 4 5 11 10 9
     call l_box -cyc_build 3 4 12 11 10
     call l_box -cyc_build 0 0 13 12 11
   :fi_b8b
   goto exit
 :fi_b8

 REM Remove: ==================================================================

 REM Box cycle:

 if not %1 == -cyc_remove goto fi_cr
   if not %2 == 0 reply -bottom %2
   if not %3 == 0 reply -shadow %3
   if not %4 == 0 reply -stripe %4 %REPLY_PATTERN% %REPLY_LETTER%
   if not %5 == 0 reply -top %5
   if not %6 == 0 reply -stripe %6 %REPLY_PATTERN% %REPLY_LETTER%
   goto exit
 :fi_cr

 REM Box, y-offset=13: --------------------------------------------------------

 if not %1 == -remove goto fi_r
   if not %GMS_ANIMATE% == on goto else_rr
     call l_box -cyc_remove 20 21 22 4 3
     call l_box -cyc_remove 19 20 21 5 4
     call l_box -cyc_remove 18 19 20 6 5
     call l_box -cyc_remove 17 18 19 7 6
     call l_box -cyc_remove 16 17 18 8 7
     call l_box -cyc_remove 15 16 17 9 8
     call l_box -cyc_remove 14 15 16 10 9
     call l_box -cyc_remove 13 14 15 11 10
     call l_box -cyc_remove 12 13 14 12 11
     call l_box -cyc_remove 0 12 13 0 12
     REM                          `- Offset
     goto exit
   :else_rr
     for %%i in (3 22 4) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (21 5 20) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (6 19 7) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (18 8 17) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (9 16 10) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (15 11 14) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (12 13) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
   :fi_rr
   goto exit
 :fi_r

 REM Top box, y-offset=12: ----------------------------------------------------

 if not %1 == -t12_remove goto fi_r2
   if not %GMS_ANIMATE% == on goto else_r2r
     call l_box -cyc_remove 18 19 20 4 3
     call l_box -cyc_remove 17 18 19 5 4
     call l_box -cyc_remove 16 17 18 6 5
     call l_box -cyc_remove 15 16 17 7 6
     call l_box -cyc_remove 14 15 16 8 7
     call l_box -cyc_remove 13 14 15 9 8
     call l_box -cyc_remove 12 13 14 10 9
     call l_box -cyc_remove 11 12 13 11 10
     call l_box -cyc_remove 0 11 12 0 11
     REM                          `- Offset
     goto exit
   :else_r2r
     for %%i in (3 20 4) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (19 5 18) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (6 17 7) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (16 8 15) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (9 14 10) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (13 11 12) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
   :fi_r2r
   goto exit
 :fi_r2

 REM Top box, y-offset=11: ----------------------------------------------------

 if not %1 == -t11_remove goto fi_r1
   if not %GMS_ANIMATE% == on goto else_r1r
     call l_box -cyc_remove 16 17 18 4 3
     call l_box -cyc_remove 15 16 17 5 4
     call l_box -cyc_remove 14 15 16 6 5
     call l_box -cyc_remove 13 14 15 7 6
     call l_box -cyc_remove 12 13 14 8 7
     call l_box -cyc_remove 11 12 13 9 8
     call l_box -cyc_remove 10 11 12 10 9
     call l_box -cyc_remove 0 10 11 0 10
     REM                          `- Offset
     goto exit
   :else_r1r
     for %%i in (3 18 4) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (17 5 16) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (6 15 7) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (14 8 13) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (9 12) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (10 11) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
   :fi_r1r
   goto exit
 :fi_r1

 REM Top box, y-offset=8: -----------------------------------------------------

 if not %1 == -t8_remove goto fi_r8
   if not %GMS_ANIMATE% == on goto else_r8r
     call l_box -cyc_remove 13 0 0 0 0
     call l_box -cyc_remove 12 13 0 0 0
     call l_box -cyc_remove 11 12 13 3 0
     call l_box -cyc_remove 10 11 12 4 3
     call l_box -cyc_remove 9 10 11 5 4
     call l_box -cyc_remove 8 9 10 6 5
     call l_box -cyc_remove 7 8 9 7 6
     call l_box -cyc_remove 0 7 8 0 7
     REM                        `- Offset
     goto exit
   :else_r8r 
     for %%i in (3 13 4) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (12 5 11) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (6 10 7) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
     for %%i in (9 8) do reply -stripe %%i %REPLY_PATTERN% %REPLY_LETTER%
   :fi_r8r
   goto exit
 :fi_r8

 REM Not found: ---------------------------------------------------------------

 :else
   call l_banner -no_action l_box %1 
 :fi

 :exit
