 REM l_banner.bat
 REM ============

 REM This file is part of Gerolf Markup Shredder,
 REM written by G. D. Brettschneider (1999-2006).

 REM set GMSdateL_BANNER=20060927

 REM Prologue: ================================================================

 REM Debug: Banners are out of the X/Y-debugging system (which uses banners)...

 if "%OS%" == "" goto fi_db1
 if -%GMS_DEBUG% == - goto exit
 REM if %GMS_DEBUG% == Z echo %0 (%1) (%2) (%3) (%4) (%5) (%6) (%7) (%8)>> %Z%
 :fi_db1

 REM Size: --------------------------------------------------------------------

 set BACKUP_SIZE=%REPLY_SIZE%
 set REPLY_SIZE=78

 set BACKUP_OFFSET=%REPLY_OFFSET%
 set REPLY_OFFSET=0

 REM Chapters: ================================================================

 REM Not running:

 if not "%1" == "" goto fi_se
   echo  G e r o l f   M a r k u p   S h r e d d e r   (l_banner)   . . .
   pause > nul
   gerolf 2> nul
   goto exit
 :fi_se

 REM Debug: -------------------------------------------------------------------

 if not %1 == -debug goto fi_db
 REM Upper:
   set REPLY_OFFSET=0
   set REPLY_SIZE=22
   reply -banner 2 "Module: %2"
   set REPLY_OFFSET=19
   set REPLY_SIZE=22
   reply -banner 2 "Action: %3"
   set REPLY_OFFSET=38
   set REPLY_SIZE=22
   reply -banner 2 "Hotkey: %4"
   set REPLY_OFFSET=57
   set REPLY_SIZE=25
   reply -banner 2 "Coldkey: %5"
 REM Lower:
   set REPLY_OFFSET=0
   set REPLY_SIZE=22
   reply -banner 23 "Offset: %BACKUP_OFFSET%"
   set REPLY_OFFSET=19
   set REPLY_SIZE=22
   reply -banner 23 "Size: %BACKUP_SIZE%"
   set REPLY_OFFSET=38
   set REPLY_SIZE=22
   reply -banner 23 "Items: %REPLY_ITEMS%"
   set REPLY_OFFSET=57
   set REPLY_SIZE=25
   reply -banner 23 "Data: %6"
   if %GMS_DEBUG% == Y reply -sleep
   goto exit
 :fi_db

 REM Diverse: -----------------------------------------------------------------

 REM No module:
 if not %1 == -no_module goto fi_nm
   reply -banner 1 "GMS error: No module '%2'"
   set REPLY_OFFSET=57
   set REPLY_SIZE=25
   reply -banner 1 "Gerolf Markup Shredder"
   reply -sleep
   goto exit
 :fi_nm

 REM No action:
 if not %1 == -no_action goto fi_na
   reply -banner 1 "GMS error: No action '%3'"
   set REPLY_OFFSET=57
   set REPLY_SIZE=25
   reply -banner 1 "Module: '%2'"
   reply -sleep
   goto exit
 :fi_na

 REM No hot:
 if not %1 == -no_hot goto fi_nh
   reply -banner 1 "GMS error: No hotkey '%3'"
   set REPLY_OFFSET=57
   set REPLY_SIZE=25
   reply -banner 1 "Module: '%2'"
   reply -sleep
   goto exit
 :fi_nh

 REM No cold:
 if not %1 == -no_cold goto fi_nc
   reply -banner 1 "GMS error: No coldkey '%3'"
   set REPLY_OFFSET=57
   set REPLY_SIZE=25
   reply -banner 1 "Module: '%2'" 
   reply -sleep
   goto exit
 :fi_nc

 REM No file:
 if not %1 == -no_file goto fi_nf
   reply -banner 1 "GMS error: No file."
   set REPLY_OFFSET=57
   set REPLY_SIZE=25
   reply -banner 1 "Module: '%2'"
   reply -sleep 
   goto exit
 :fi_nf

 REM Upper: -------------------------------------------------------------------

 if not %1 == -upper goto fi_u

   REM First upper banner:
   if not %2 == -first goto fi_u1
     reply -banner 1 "Gerolf Markup Shredder %GMS_VERSION%"
     set REPLY_OFFSET=54
     set REPLY_SIZE=27
     reply -banner 1 "MarkupShredder@Gerolf.org "
     goto exit
   :fi_u1

   REM Last upper banner:
   if not %2 == -last goto fi_ult
     reply -banner 1 "MarkupShredder@Gerolf.org"
     set REPLY_OFFSET=65
     set REPLY_SIZE=16
     reply -banner 1 "www.Gerolf.org"
     goto exit
   :fi_ult

   REM Write handbook title on upper banner:
   if not %2 == -handbook goto fi_uht
     reply -banner 1 "%GMS_FILE%"
     set REPLY_OFFSET=44
     set REPLY_SIZE=38
     reply -banner 1 "The Gerolf Markup Shredder Handbook"
     goto exit
   :fi_uht

   REM Write current file on upper banner:   
   REM This does not work on DOS:
     if not %2 == -file goto fi_uf
       reply -banner 1 "%GMS_FILE%"
       set REPLY_OFFSET=57
       set REPLY_SIZE=25
       reply -banner 1 "Gerolf Markup Shredder "
       goto exit
     :fi_uf

   REM Write current template on upper banner:
   if not %2 == -template goto fi_ut
     reply -banner 1 "Template: %GMS_TEMPLATEFILE%"
     set REPLY_OFFSET=57
     set REPLY_SIZE=25
     reply -banner 1 "Gerolf Markup Shredder"
     goto exit
   :fi_ut

   REM Write help text for codepage (upper half):
   if not %2 == -cp_up goto fi_ucu
     reply -banner 1 "Terminal codepage (upper half): cp%GMS_CURCP%"
     set REPLY_OFFSET=57
     set REPLY_SIZE=24
     reply -banner 1 "Gerolf Markup Shredder "
     goto exit
   :fi_ucu

   if not %2 == -cp_up_dos goto fi_ucv
     reply -banner 1 "Upper half"
     set REPLY_OFFSET=57
     set REPLY_SIZE=24
     reply -banner 1 "Gerolf Markup Shredder "
     goto exit
   :fi_ucv
   
   REM Write help text for codepage (lower half):
   if not %2 == -cp_lo goto fi_ucl
     reply -banner 1 "American Standard Code for Information Interchange"
     set REPLY_OFFSET=51
     set REPLY_SIZE=31
     reply -banner 1 " (only if in range 32 - 126) " X
     goto exit
   :fi_ucl
   
 :fi_u

 REM Lower: -------------------------------------------------------------------

 if not %1 == -lower goto else_l

   REM Write domain on lower banner:
   if not %2 == -domain goto fi_ldo
     set REPLY_OFFSET=65
     set REPLY_SIZE=16
     reply -banner 24 "www.Gerolf.org"
     goto exit
   :fi_ldo

   REM First lower banner:
   if not %2 == -first goto fi_lft
     reply -banner 24 "The typesetting program that uses TeX for"
     set REPLY_OFFSET=43
     set REPLY_SIZE=38
     reply -banner 24 "document conversion from HTML to PDF "
     goto exit
   :fi_lft

   REM Write current folder on lower banner:
   if not %2 == -folder goto fi_lfo
     REM There must be one space before the second quoting mark for 'C:\' etc.:
     reply -banner 24 "%GMS_FOLDER% "
     set REPLY_OFFSET=65
     set REPLY_SIZE=16
     reply -banner 24 "www.Gerolf.org "
     goto exit
   :fi_lfo

   REM Write warning for select dialog:
   if not %2 == -select goto fi_lse
     reply -banner 24 "Warning: Changes done here will be written"
     set REPLY_OFFSET=44
     set REPLY_SIZE=38
     reply -banner 24 "to the GMS launcher script 'gerolf'"
     goto exit
   :fi_lse

   REM Write help text for menu animation:
   if not %2 == -animate goto fi_lan
     reply -banner 24 "Menu animation is currently turned %GMS_ANIMATE%"
     set REPLY_OFFSET=65
     set REPLY_SIZE=16
     reply -banner 24 "www.Gerolf.org"
     goto exit
   :fi_lan

   REM Write help text for debugging:
   if not %2 == -debug goto fi_ldb
     reply -banner 24 "X: trace modules, Y: slow motion, Z: write log,"
     set REPLY_OFFSET=49
     set REPLY_SIZE=32
     reply -banner 24 "0: no debug.    www.Gerolf.org"
     goto exit
   :fi_ldb

   REM Write help text for encoding:
   if not %2 == -encode goto fi_len
     reply -banner 24 "CP1250 East, CP1251 Cyril, CP1252 West,"
     set REPLY_OFFSET=41
     set REPLY_SIZE=41
     reply -banner 24 "CP1253 Greek, CP1254 Turk, CP1256 Arab"
     goto exit
   :fi_len

   REM Write help text for color dialog:
   if not %2 == -color goto fi_lcr
     reply -banner 24 "Enter a color or ASCII letter number"
     set REPLY_OFFSET=38
     set REPLY_SIZE=44
     reply -banner 24 "(or 'R' for random changes of appearance) "
     goto exit
   :fi_lcr

   REM Write help text for codepage:
   if not %2 == -codepage goto fi_lcp
     reply -banner 24 "Show terminal codepage"
     set REPLY_OFFSET=65
     set REPLY_SIZE=16
     reply -banner 24 "www.Gerolf.org"
     goto exit
   :fi_lcp
   
   REM Write help text for terminal font:
   if not %2 == -terminal goto fi_ltl
     reply -banner 24 "You may have to change the terminal"
     set REPLY_OFFSET=37
     set REPLY_SIZE=45
     reply -banner 24 "font to display the appropriate characters "
     goto exit
   :fi_ltl

   REM Write help text for programs:
   if not %2 == -program goto fi_lpm
     reply -banner 24 "Select programs to associate with GMS menu items"
     set REPLY_OFFSET=65
     set REPLY_SIZE=16
     reply -banner 24 "www.Gerolf.org"
    goto exit
   :fi_lpm

   REM Write help text for viewer:
 REM Fixme: should depend on OS:
   if not %2 == -viewer goto fi_lvw
     reply -banner 24 "Text viewers: more, browse, list, ..."
     set REPLY_OFFSET=65
     set REPLY_SIZE=16
     reply -banner 24 "www.Gerolf.org"
     goto exit
   :fi_lvw

   REM Write help text for editor:
 REM Fixme: should depend on OS:
   if not %2 == -editor goto fi_led
     reply -banner 24 "Text editors: notepad, wordpad, html-kit, frontpg, ..."
     set REPLY_OFFSET=65
     set REPLY_SIZE=16
     reply -banner 24 "www.Gerolf.org"
     goto exit
   :fi_led

   REM Write help text for browser:
   if not %2 == -browser goto fi_lbr
     reply -banner 24 "HTML browsers: lynx, links, mozilla, iexplore"
     set REPLY_OFFSET=37
     set REPLY_SIZE=45
     reply -banner 24 "netscape, opera, amaya, ..." 
     goto exit
   :fi_lbr

   REM Write help text for analyst:
   if not %2 == -analyst goto fi_lay
     reply -banner 24 "HTML syntax checker: tidy"
     set REPLY_OFFSET=65
     set REPLY_SIZE=16
     reply -banner 24 "www.Gerolf.org"
     goto exit
   :fi_lay

   REM Write help text for typesetter:

   if not %2 == -tsetter goto fi_lts
     reply -banner 24 "HTML typesetters: pdfetex, pdftex, etex, tex"
     set REPLY_OFFSET=65
     set REPLY_SIZE=16
     reply -banner 24 "www.Gerolf.org"
     goto exit
   :fi_lts

   REM Write help text for reader:

   if not %2 == -reader goto fi_lrr
     reply -banner 24 "PDF readers: acrord32, gv, ghostview, xpdf, ..."
     set REPLY_OFFSET=65
     set REPLY_SIZE=16
     reply -banner 24 "www.Gerolf.org"
     goto exit
   :fi_lrr

 REM Error: -------------------------------------------------------------------

 :else_l
   echo GMS error: No l_banner %1 %2
   reply -sleep
 :fi

 :exit

 REM Epilogue: ================================================================

 set REPLY_OFFSET=%BACKUP_OFFSET%
 set BACKUP_OFFSET=

 set REPLY_SIZE=%BACKUP_SIZE%
 set BACKUP_SIZE=
