 echo off
 if not "%2" == "-quiet" if not "%3" == "-quiet" cls
 
 REM gms.bat
 REM =======

 REM This file is part of Gerolf Markup Shredder,
 REM written by G. D. Brettschneider (1999-2006).

 REM set GMSdateGMS=20060927

 REM Prologue: ================================================================
 
 REM Start shell:
 
 if "%1" == "-shell" goto th_sh
 if "%comspec%" == "" echo Please set COMSPEC variable. Press any key ...
 if "%comspec%" == "" pause > nul
 if "%comspec%" == "" goto fi_sh
   %comspec% /E:4096 /C %0 -shell %1 %2 %3 %4 %5 %6 %7 %8 %9
   goto exit
 :th_sh
   shift
 :fi_sh
 
 REM Trace launcher parameters in debug log file:

 if not (%1) == (-trace_launcher) goto fi_trace
    if "%OS%" == "" goto exit
    if %Z% == "" goto exit
    shift
    echo gerolf (%1) (%2) (%3) (%4) (%5) (%6) (%7) (%8) (%9)>> %Z%
    goto exit
 :fi_trace
   
 REM Debug: -------------------------------------------------------------------

 if "%OS%" == "" goto fi_db
 if -%GMS_DEBUG% == - goto fi_db
 if %GMS_DEBUG% == Z echo %0 (%1) (%2) (%3) (%4) (%5) (%6) (%7) (%8)>> %Z%
 if %GMS_DEBUG% == X goto then_db
 if not %GMS_DEBUG% == Y goto fi_db
 :then_db
   set REPLY_BANNER=2
   set REPLY_TEXT=15
   call l_banner -debug gms %1 %2 %3 %4
 :fi_db
  
 REM 1. Check common variables: ===============================================

 REM If necesssary, read launcher script to load environment:

 if not "%GMS_BATCH%" == "" goto fi_ll
   call gerolf -passive %1 %2 %3 %4 %5 %6 %7 %8 %9
   if "%GMS_STARTUP%" == "" set GMS_STARTUP=%PWD%
   cls
   if "%OS%" == "" type %GMS_SETTING%\launch_3.scn
   if not "%OS%" == "" type "%GMS_SETTING%\launch_3.scn"
   if not "%GMS_BATCH%" == "" goto fi_lll
     cls
     echo  GMS error: Could not set environment variables.
     echo  Run "gmssetup" to create GMS launcher script "gerolf"!
     echo.
     goto exit 
   :fi_lll
 :fi_ll 
     
 REM 2. Check chapter variable: ===============================================

 REM GMS is not yet running:

 if not (%1) == () goto fi_nr
   cls
   if "%OS%" == "" type %GMS_SETTING%\welcome.scn
   if not "%OS%" == "" type "%GMS_SETTING%\welcome.scn"
   call l_gms -welcome called_by gms
   pause > nul
   goto help
 :fi_nr

 REM Remove optional "-mime" argument at first position (browser interface):

 if not %1 == -mime goto fi_mf
   if (%2) == () goto else_mr
   if not %2 == -read goto else_mr
     echo Content-type: application\pdf
     goto fi_mr
   :else_mr
     echo Content-type: text\plain
   :fi_mr
   shift
 :fi_mf
         
 REM Chapters: ================================================================

 if (%1) == () goto exit

 REM Quit: --------------------------------------------------------------------

 if (%1) == (-q) goto then_q
 if (%1) == (-Q) goto then_q
 if (%1) == (--q) goto then_q
 if (%1) == (--Q) goto then_q
 if (%1) == (/q) goto then_q
 if (%1) == (/Q) goto then_q
 if (%1) == (q) goto then_q
 if (%1) == (Q) goto then_q
 if (%1) == (qq) goto then_q
 if not (%1) == (QQ) goto fi_q
 :then_q
   cls
 REM call l_gms -goodbye called_by gms -Q
   if not "%GMS_TEXTMODE%" == "" goto fi_q1
     if "%OS%" == "" type %GMS_SETTING%\goodbye.scn
     if not "%OS%" == "" type "%GMS_SETTING%\goodbye.scn"
   :fi_q1
 REM Remove temporary files:
   if (%1) == (-Q) goto then_q2
   if (%1) == (/Q) goto then_q2
   if (%1) == (Q) goto then_q2
   if not (%1) == (QQ) goto fi_q2
   :then_q2
     if exist *.log del *.log
     if exist *.ok del *.ok
     if exist *.err del *.err
   :fi_q2
 REM Return to startup folder:
   if "%GMS_STARTUP%" == "" goto fi_q3
     if "%OS%" == "" if exist %GMS_STARTUP%\%any% cd %GMS_STARTUP% > nul
     if not "%OS%" == "" if exist "%GMS_STARTUP%\%any%" cd "%GMS_STARTUP%"> nul
   :fi_q3
   call g_vars -write_memo
 REM Restore environment:
   call g_vars -clear called_by gms -q
   if "%3" == "g_good" goto exit
   REM Final unsets:
     set GMS_BREAK=
     set GMS_DEBUG=
     set GMS_SETTING=
     set Z=
  REM pause
   goto exit
 :fi_q

 REM Create: ------------------------------------------------------------------

 if (%1) == (-c) goto then_c
 if (%1) == (-C) goto then_c
 if (%1) == (--c) goto then_c
 if (%1) == (--C) goto then_c
 if (%1) == (/c) goto then_c
 if (%1) == (/C) goto then_c
 if (%1) == (c) goto then_c
 if (%1) == (C) goto then_c
 if (%1) == (cc) goto then_c
 if not (%1) == (CC) goto fi_c
 :then_c
   set GMS_FILE=%2
   set GMS_MESSAGE=%GMS_FILE%
 REM Check if there is an old file with that name:
   if "%OS%" == "" if not exist %GMS_FILE% goto fi_c1
   if not "%OS%" == "" if not exist "%GMS_FILE%" goto fi_c1
     set GMS_MESSAGE=GMS error: Did not overwrite existing file %GMS_FILE%
     goto fi_c5
   :fi_c1
 REM Look for template in current directory and copy it:
   if (%3) == () goto else_c5
   if "%OS%" == "" if not exist %3 goto fi_c2
   if not "%OS%" == "" if not exist "%3" goto fi_c2
     if "%OS%" == "" copy %3 %GMS_FILE% > nul
     if not "%OS%" == "" copy "%3" "%GMS_FILE%" > nul 2> nul
     call g_vars -ini_file %2
 rem call g_vars -abort called_by gms -c
     goto fi_c5
   :fi_c2
 REM Look for template in template directory and copy it:
   if "%OS%" == "" if not exist %GMS_TEMPLATE%\%3\%3.htm goto fi_c3
   if not "%OS%" == "" if not exist "%GMS_TEMPLATE%\%3\%3.htm" goto fi_c3
     if "%OS%" == "" copy %GMS_TEMPLATE%\%3\%3.htm %GMS_FILE%> nul
     if not "%OS%" == "" copy "%GMS_TEMPLATE%\%3\%3.htm" "%GMS_FILE%" > nul
     call g_vars -ini_file %2
 rem call g_vars -abort called_by gms -c
     goto fi_c5
   :fi_c3
   if "%OS%" == "" if not exist %GMS_TEMPLATE%\%3 goto else_c5
   if not "%OS%" == "" if not exist "%GMS_TEMPLATE%\%3" goto else_c5
     if "%OS%" == "" copy %GMS_TEMPLATE%\%3 %GMS_FILE%> nul
     if not "%OS%" == "" copy "%GMS_TEMPLATE%\%3" "%GMS_FILE%" > nul
     call g_vars -ini_file %2
 rem call g_vars -abort called_by gms -c
     goto fi_c5
   :else_c5
     set GMS_MESSAGE=GMS: Creating default file. There is no template %3
     if "%OS%" == "" copy %GMS_TEMPLATE%\default\default.htm %GMS_FILE% > nul
 if not "%OS%" == "" copy "%GMS_TEMPLATE%\default\default.htm" "%GMS_FILE%">nul
    :fi_c5
  goto help
 :fi_c

 REM Open: --------------------------------------------------------------------

 if (%1) == (-o) goto then_o
 if (%1) == (-O) goto then_o
 if (%1) == (--o) goto then_o
 if (%1) == (--O) goto then_o
 if (%1) == (/o) goto then_o
 if (%1) == (/O) goto then_o
 if (%1) == (o) goto then_o
 if (%1) == (O) goto then_o
 if (%1) == (oo) goto then_o
 if not (%1) == (OO) goto fi_o
 :then_o
   shift
   if (%1) == () set GMS_FILE=
   if (%1) == () goto help
   call g_vars -ini_file %1 %2 %3 %4 %5 %6 %7 %8 %9
   goto help
 :fi_o

 REM View: --------------------------------------------------------------------

 if (%1) == (-v) goto then_v
 if (%1) == (-V) goto then_v
 if (%1) == (--v) goto then_v
 if (%1) == (--V) goto then_v
 if (%1) == (/v) goto then_v
 if (%1) == (/V) goto then_v
 if (%1) == (v) goto then_v
 if (%1) == (V) goto then_v
 if (%1) == (vv) goto then_v
 if not (%1) == (VV) goto fi_v
 :then_v
   set GMS_COMMAND=%GMS_VIEWER%
   %GMS_REMODRV%
   goto then_x
 :fi_v

 REM Edit: --------------------------------------------------------------------

 if (%1) == (-e) goto then_e
 if (%1) == (-E) goto then_e
 if (%1) == (--e) goto then_e
 if (%1) == (--E) goto then_e
 if (%1) == (/e) goto then_e
 if (%1) == (/E) goto then_e
 if (%1) == (e) goto then_e
 if (%1) == (E) goto then_e
 if (%1) == (ee) goto then_e
 if not (%1) == (EE) goto fi_e
 :then_e
   set GMS_PROGRAM=text editor
   set GMS_COMMAND=%GMS_EDITOR%
   goto then_x 
 :fi_e

 REM Browse: ------------------------------------------------------------------

 if (%1) == (-b) goto then_b
 if (%1) == (-B) goto then_b
 if (%1) == (--b) goto then_b
 if (%1) == (--B) goto then_b
 if (%1) == (/b) goto then_b
 if (%1) == (/B) goto then_b
 if (%1) == (b) goto then_b
 if (%1) == (B) goto then_b
 if (%1) == (bb) goto then_b
 if not (%1) == (BB) goto fi_b
 :then_b
   if "%GMS_FILE%" == "_folder.err" goto help
   set GMS_PROGRAM=markup file browser
   set GMS_COMMAND=%GMS_BROWSER%
   goto then_x 
 :fi_b

 REM Analyse folder kernel: ---------------------------------------------------

 if not (%1) == (-analyse_kernel) goto fi_ak
 REM Check file:
   set GMS_BASEn=%2
   if not "%OS%" == "" goto fi_ak1
     echo %2 > in.txt
     if exist in.txt sed "s/\..*$//;s/^/set GMS_BASEn=/" < in.txt > out.bat
     if exist out.bat call out.bat
     if exist in.txt del in.txt 
     if exist out.bat del out.bat 
   :fi_ak1
   if "%OS%" == "" set arg=-config %GMS_SETTING%\tidy.cfg
   if not "%OS%" == "" set arg=-config "%GMS_SETTING%\tidy.cfg" 
     %GMS_ANALYST% %arg% -f %GMS_BASEn%.er_ %2 > %GMS_BASEn%.ok
   set arg=
 REM Show results on screen:
   echo  _folder.err - GMS: Running %GMS_PROGRAM% ...
   echo.
   echo __________________________________________________
   echo.
   echo  %2
   echo.
   if exist %GMS_BASEn%.err_ type %GMS_BASEn%.er_
 REM Write results to error file:
   echo __________________________________________________ >> _folder.err
   echo. >> _folder.err
   echo  %2 >> _folder.err
   echo. >> _folder.err
   if exist %GMS_BASEn%.er_ type %GMS_BASEn%.er_ >> _folder.err
   if exist %GMS_BASEn%.er_ del %GMS_BASEn%.er_
   if exist %GMS_BASEn%.ok del %GMS_BASEn%.ok
   set GMS_BASEn=
   goto exit
 :fi_ak

 REM Analyse file or all files in folder: -------------------------------------

 if (%1) == (-a) goto then_a
 if (%1) == (-A) goto then_a
 if (%1) == (--a) goto then_a
 if (%1) == (--A) goto then_a
 if (%1) == (/a) goto then_a
 if (%1) == (/A) goto then_a
 if (%1) == (a) goto then_a
 if (%1) == (A) goto then_a
 if (%1) == (aa) goto then_a
 if not (%1) == (AA) goto fi_a
 :then_a
   if "%OS%" == "" goto fi_a1
     echo    GMS_FOLDER=%GMS_FOLDER%>> %Z%
     echo    GMS_FILE=%GMS_FILE%>> %Z%
     echo    GMS_SHORT=%GMS_SHORT%>> %Z%
     echo    GMS_BASE=%GMS_BASE%>> %Z%
   :fi_a1
   if not "%2" == "" shift   
   %GMS_REMODRV%
 REM If no file is specified, check folder:
   if "%GMS_FILE%" == "" set GMS_FILE=_folder.err
   if not %GMS_FILE% == _folder.err goto else_a2
   set GMS_PROGRAM=markup syntax checker
   REM Process folder:
    cls
     set slashline=//////////////////////////////
     if "%OS%" == "Windows_9x" set slashline=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
     if "%winbootdir%" == "." set slashline=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
     set slashies=////////////////////
     if "%OS%" == "Windows_9x" set slashies=XXXXXXXXXXXXXXXXXXXX
     if "%winbootdir%" == "." set slashies=XXXXXXXXXXXXXXXXXXXX
       echo  _folder.err - GMS: Running %GMS_PROGRAM% ...
       echo %slashline%%slashline%%slashies%
       echo  _folder.err - GMS: Running %GMS_PROGRAM% ... > _folder.err
       echo %slashline%%slashline%%slashies% >> _folder.err
       for %%i in (*.htm*) do call gms -analyse_kernel %%i
       echo %slashline%%slashline%%slashies%
       echo  %GMS_FOLDER%
       echo %slashline%%slashline%%slashies% >> _folder.err
       echo  %GMS_FOLDER% >> _folder.err
     set slashline=
     set slashies=
   REM Show results:
     set GMS_COMMAND=%GMS_VIEWER%
     set appbanner=markup syntax checker
       call g_vars -execute "%appbanner%" %GMS_VIEWER% %GMS_FOLDER%\_folder.err
     set appbanner=
     set i=
     goto fi_a2
   :else_a2
     set backup_file=%GMS_FILE%
     set backup_base=%GMS_BASE%
     set backup_short=%GMS_SHORT%
     set GMS_PROGRAM=markup syntax checker
     set GMS_COMMAND=%GMS_VIEWER%
  if not "%GMS_MODE%" == "quiet" if "%GMS_FreeDOS%" == "" mode con lines=25>nul
     if not "%GMS_MODE%" == "quiet" if not "%GMS_FreeDOS%" == "" mode co80,25
     if not "%2" == "-quiet" echo. %GMS_FILE%
     if "%OS%" == "" if not "%2" == "-quiet" type %GMS_SETTING%\desktop.scn
   if not "%OS%" == "" if not "%2" == "-quiet" type "%GMS_SETTING%\desktop.scn"
     if not "%2" == "-quiet" echo. %GMS_FOLDER%
     set GMS_FILE=%backup_file%
   REM Run HTML Tidy:  
     if "%OS%" == "" set arg=-config %GMS_SETTING%\tidy.cfg -f %GMS_BASE%.pmt
     if not "%OS%" == "" set arg=-config "%GMS_SETTING%\tidy.cfg" 
     if not "%OS%" == "" set arg=%arg% -f "%GMS_BASE%.pmt"
     if not %GMS_DEBUG% == Z goto fi_a21
     if "%OS%" == "" goto fi_a21
       echo   GMS_ANALYST=%GMS_ANALYST%>> %Z%
     :fi_a21
     if "%OS%" == "" if exist %GMS_FOLDER%\%any% cd %GMS_FOLDER%
     if not "%OS%" == "" if exist "%GMS_FOLDER%\%any%" cd "%GMS_FOLDER%"
     if not "%GMS_DRDOS%" == "" cd %GMS_FOLDER%
     if exist %GMS_BASE%.err del %GMS_BASE%.err
     if not "%OS%" == "Windows_9x" set arg1=%GMS_BASE%.ok
     if "%OS%" == "Windows_9x" set arg1=nul
       call %GMS_ANALYST% %arg% %GMS_FILE% > %arg1%
     set arg1=
     set arg=
   set GMS_FILE=%GMS_BASE%.err
   set GMS_SHORT=%GMS_BASE%.err
   if not "%OS%" == "Windows_9x" set arg=\n\n\n\n\n\n\n\n\n\n\n\n
   if "%OS%" == "" set arg=\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n
     sed "s/^No warnings.*/&%arg%/" < %GMS_BASE%.pmt > %GMS_BASE%.tmp
   set arg=
   if not "%OS%" == "Windows_9x" goto fi_a9x
     echo. >> %GMS_BASE%.tmp
     echo. >> %GMS_BASE%.tmp
     echo. >> %GMS_BASE%.tmp
     echo. >> %GMS_BASE%.tmp
     echo. >> %GMS_BASE%.tmp
     echo. >> %GMS_BASE%.tmp
     echo. >> %GMS_BASE%.tmp
     echo. >> %GMS_BASE%.tmp
     echo. >> %GMS_BASE%.tmp
     echo. >> %GMS_BASE%.tmp
     echo. >> %GMS_BASE%.tmp
     echo. >> %GMS_BASE%.tmp
   :fi_a9x
   if "%GMS_MODE%" == "quiet" goto fi_a22
     set slashline=//////////////////////////////
     if "%OS%" == "Windows_9x" set slashline=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
     if "%winbootdir%" == "." set slashline=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
     set slashies=////////////////////
     if "%OS%" == "Windows_9x" set slashies=XXXXXXXXXXXXXXXXXXXX
     if "%winbootdir%" == "." set slashies=XXXXXXXXXXXXXXXXXXXX
       echo  %GMS_FILE% - GMS: Running %GMS_PROGRAM% ...> errhead.err
       echo %slashline%%slashline%%slashies%>> errhead.err
       echo %slashline%%slashline%%slashies%> errfoot.err
       echo  %GMS_FOLDER% >> errfoot.err
     set slashline=
     set slashies=
     copy errhead.err + %GMS_BASE%.tmp + errfoot.err %GMS_BASE%.err > nul
   :fi_a22
   if "%GMS_MODE%" == "quiet" ren %GMS_BASE%.tmp %GMS_BASE%.err > nul
     if not "%GMS_MODE%" == "quiet" if exist %GMS_BASE%.pmt del %GMS_BASE%.pmt
     if not "%GMS_MODE%" == "quiet" if exist %GMS_BASE%.tmp del %GMS_BASE%.tmp
     if exist errhead.err del errhead.err
     if exist errfoot.err del errfoot.err
   if "%GMS_MODE%" == "quiet" goto fi_a2
     cls
  if not "%GMS_MODE%" == "quiet" if "%GMS_FreeDOS%" == "" mode con lines=25>nul
     if not "%GMS_MODE%" == "quiet" if not "%GMS_FreeDOS%" == "" mode co80,25
     if not "%2" == "-quiet" echo. %GMS_FILE%
     if "%OS%" == "" if not "%2" == "-quiet" type %GMS_SETTING%\desktop.scn
   if not "%OS%" == "" if not "%2" == "-quiet" type "%GMS_SETTING%\desktop.scn"
     if not "%2" == "-quiet" echo  %GMS_FOLDER%
   :fi_a2
   if not "%GMS_ERRSHORT%" == "" goto fi_a3
     call g_dos -chdir called_by gms -a
     set GMS_ERRBASE=%GMS_BASE%
     set GMS_ERRSHORT=%GMS_SHORT%
   :fi_a3
   set GMS_BASE=%GMS_ERRBASE%
   set GMS_SHORT=%GMS_ERRSHORT%
   goto then_x
 :fi_a

 REM Typeset: -----------------------------------------------------------------

 if (%1) == (-t) goto then_t
 if (%1) == (-T) goto then_t
 if (%1) == (--t) goto then_t
 if (%1) == (--T) goto then_t
 if (%1) == (/t) goto then_t
 if (%1) == (/T) goto then_t
 if (%1) == (t) goto then_t
 if (%1) == (T) goto then_t
 if (%1) == (tt) goto then_t
 if not (%1) == (TT) goto fi_t
 :then_t
   if "%OS%" == "" if exist %GMS_FONTS%\tfm\*.tfm goto fi_tt
   if not "%OS%" == "" if exist "%GMS_FONTS%\tfm\*.tfm" goto fi_tt
     echo  GMS error: TeX font metrics not found. Please 'Write font map'.
     if "%OS%" == "" type %GMS_SETTING%\desktop.scn
     if not "%OS%" == "" type "%GMS_SETTING%\desktop.scn"
     echo  %GMS_FONTS%\tfm
     reply -sleep
     reply -sleep
     reply -sleep
     goto exit
   :fi_tt
   if "%OS%" == "" if exist %GMS_SETTING%\font.map goto fi_ttt
   if not "%OS%" == "" if exist "%GMS_SETTING%\font.map" goto fi_ttt 
     echo  GMS error: Missing font information. Please 'Write font map'.
     if "%OS%" == "" type %GMS_SETTING%\desktop.scn
     if not "%OS%" == "" type "%GMS_SETTING%\desktop.scn"
     echo  %GMS_SETTING%
     reply -sleep
     reply -sleep
     reply -sleep
     goto exit
   :fi_ttt   
   if "%GMS_FILE%" == "_folder.err" goto help
   set backup_file=%GMS_FILE%
   set backup_base=%GMS_BASE%
   set backup_short=%GMS_SHORT%
   set GMS_COMMAND=%GMS_VIEWER%
   set GMS_FILE=%GMS_BASE%.log
   cls
  if not "%GMS_MODE%" == "quiet" if "%GMS_FreeDOS%" == "" mode con lines=25>nul
   if not "%GMS_MODE%" == "quiet" if not "%GMS_FreeDOS%" == "" mode co80,25
   if not "%2" == "-quiet" echo. %GMS_FILE%
   if "%OS%" == "" if not "%2" == "-quiet" type %GMS_SETTING%\desktop.scn
   if not "%OS%" == "" if not "%2" == "-quiet" type "%GMS_SETTING%\desktop.scn"
   if not "%2" == "-quiet" echo  %GMS_FOLDER%
   set GMS_PROGRAM=%GMS_TSETTER% engine
   if "%OS%" == "Windows_9x" set GMS_PROGRAM=%GMS_TSETTER% engine - please wait
     if not "%GMS_MODE%" == "quiet" call l_gms -desktop -clear called_by gms -t
   set GMS_PROGRAM=%GMS_TSETTER% engine
   set GMS_FILE=%backup_file%
   set TEXINPUTS=.\\;%TEXMFCNF%;%TEX_USER%\\
   set WEB2C=%GMS_SETTING%
     if not %GMS_DEBUG% == Z goto fi_t0
     if "%OS%" == "" goto fi_t0
       echo   GMS_TSETTER=%GMS_TSETTER%>> %Z%
       echo   GMS_REMODRV=%GMS_REMODRV%>> %Z%
       echo   GMS_FOLDER=%GMS_FOLDER%>> %Z%
       echo   GMS_FILE=%GMS_FILE%>> %Z%
       echo   GMS_SHORT=%GMS_SHORT%>> %Z%
       echo   GMS_BASE=%GMS_BASE%>> %Z%
       echo   TEXINPUTS=%TEXINPUTS%>> %Z%
     :fi_t0
     %GMS_REMODRV%
     if "%OS%" == "" if exist %GMS_FOLDER%\%any% cd %GMS_FOLDER%
     if not "%OS%" == "" if exist "%GMS_FOLDER%\%any%" cd "%GMS_FOLDER%"
     if not "%GMS_DRDOS%" == "" cd %GMS_FOLDER%
     if not "%GMS_MODE%" == "quiet" call g_dos -begin_runtime called_by gms -t
     if "%OS%" == "" echo > gmserr.log
     if "%OS%" == "" call %GMS_TSETTER% -progname=gerolf %GMS_FILE%
if not "%OS%" == "" call %GMS_TSETTER% -progname=gerolf %GMS_FILE% 2>gmserr.log
     if not "%GMS_MODE%" == "quiet" call g_dos -end_runtime called_by gms -t     
   set TEXINPUTS=
   set WEB2C=
   set GMS_FILE=%GMS_BASE%.log
   if "%GMS_MODE%" == "quiet" goto exit
   set slashline=//////////////////////////////
   if "%OS%" == "Windows_9x" set slashline=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
   if "%winbootdir%" == "." set slashline=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
   set slashies=////////////////////
   if "%OS%" == "Windows_9x" set slashies=XXXXXXXXXXXXXXXXXXXX
   if "%winbootdir%" == "." set slashies=XXXXXXXXXXXXXXXXXXXX
   echo  %GMS_FILE% - GMS: Running %GMS_PROGRAM% ...> loghd.log
   echo %slashline%%slashline%%slashies%>> loghd.log
   if exist logft.log del logft.log
   if exist readme.txt type readme.txt >> loghd.log
   if not "%GMS_MODE%" == "quiet" echo GMS run time: %REPLY_AFTER%s>logft.log
   echo %slashline%%slashline%%slashies%>> logft.log
   echo  %GMS_FOLDER%>> logft.log
   echo.>> logft.log
   set slashline=
   set slashies=
   if exist %GMS_FILE% ren %GMS_FILE% %GMS_BASE%.pmt 
   set a0=(format
    set a1=entering extended mode
     set a2=\\write18 enabled.
     sed "s/%a0%=/\n&/;s/%a1%//;s/%a2%//;/^$/d" <%GMS_BASE%.pmt >%GMS_BASE%.pmu
     sed "s/< /</g;s/ >/>/g" < %GMS_BASE%.pmu > %GMS_BASE%.tmp
     set a2=
    set a1=
   set a0=
   if "%OS%" == "Windows_9x" echo. > gmserr.log
   if not exist gmserr.log echo.>gmserr.log
   if "%GMS_MODE%" == "quiet" goto fi_t23
     copy loghd.log + %GMS_BASE%.tmp + logft.log +gmserr.log %GMS_BASE%.pmt>nul
   :fi_t23
   if "%GMS_MODE%" == "quiet" copy %GMS_BASE%.tmp+gmserr.log %GMS_BASE%.pmt>nul
   sed "$d" < %GMS_BASE%.pmt > %GMS_FILE%
     if exist %GMS_BASE%.pmt del %GMS_BASE%.pmt
     if exist %GMS_BASE%.pmu del %GMS_BASE%.pmu
     if exist %GMS_BASE%.tmp del %GMS_BASE%.tmp
     if exist loghd.log del loghd.log
     if exist logft.log del logft.log
     if exist gmserr.log del gmserr.log
   cls
  if not "%GMS_MODE%" == "quiet" if "%GMS_FreeDOS%" == "" mode con lines=25>nul
   if not "%GMS_MODE%" == "quiet" if not "%GMS_FreeDOS%" == "" mode co80,25
   if not "%2" == "-quiet" echo. %GMS_FILE%
   if "%OS%" == "" if not "%2" == "-quiet" type %GMS_SETTING%\desktop.scn
 if not "%OS%" == "" if not "%2" == "-quiet" type "%GMS_SETTING%\desktop.scn"
   if not "%2" == "-quiet" echo. %GMS_FOLDER%
   if not "%GMS_LOGSHORT%" == "" goto fi_t1
     call g_dos -chdir called_by gms -t
     set GMS_LOGBASE=%GMS_BASE%
     set GMS_LOGSHORT=%GMS_SHORT%
   :fi_t1
   set GMS_BASE=%GMS_LOGBASE%
   set GMS_SHORT=%GMS_LOGSHORT%
   goto then_x
 :fi_t

 REM Initialize TeX format: ---------------------------------------------------

 if (%1) == (-i) goto then_i
 if (%1) == (-I) goto then_i
 if (%1) == (--i) goto then_i
 if (%1) == (--I) goto then_i
 if (%1) == (/i) goto then_i
 if (%1) == (/I) goto then_i
 if (%1) == (i) goto then_i
 if (%1) == (I) goto then_i
 if (%1) == (ii) goto then_i
 if not (%1) == (II) goto fi_i
 :then_i
   %GMS_DRIVE%
   call g_plug -build called_by gms -i
   set backup_folder=%GMS_FOLDER%
   set backup_file=%GMS_FILE%
   set backup_base=%GMS_BASE%
   set backup_short=%GMS_SHORT%
   set GMS_FOLDER=%TEXFORMATS%
   set GMS_FILE=gerolf.log
   set GMS_BASE=gerolf
   set GMS_SHORT=gerolf.log
   set GMS_PROGRAM=%GMS_TSETTER% engine
   set GMS_COMMAND=%GMS_VIEWER%
   set GEROLF=*gerolf
   if %GMS_TSETTER% == tex set GEROLF=gerolf
   if %GMS_TSETTER% == pdftex set GEROLF=gerolf
   set TEXINPUTS=%TEX_BASE%\\;%TEXMFCNF%;%GMS_ROOT%\data\\;%GMS_BINARIES%
   set WEB2C=%GMS_SETTING%
   set GMS_NOREMO=1
   REM if "%OS%" == "" if not "%winbootdir%" == "." set TEXINPUTS=%GMS_ROOT%\\
     call g_dos -chdir called_by gms -i
     if not "%2" == "-quiet" if "%GMS_FreeDOS%" == "" mode con lines=25 > nul
     if not "%2" == "-quiet" if not "%GMS_FreeDOS%" == "" mode co80,25
     if not "%2" == "-quiet" call l_gms -desktop -clear called_by gms -i
     set slashline=//////////////////////////////
     if "%OS%" == "Windows_9x" set slashline=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
     if "%winbootdir%" == "." set slashline=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
     set slashies=////////////////////
     if "%OS%" == "Windows_9x" set slashies=XXXXXXXXXXXXXXXXXXXX
     if "%winbootdir%" == "." set slashies=XXXXXXXXXXXXXXXXXXXX
       echo  %GMS_FILE% - GMS: Running %GMS_PROGRAM% ...>gmshd.log
       echo %slashline%%slashline%%slashies%>> gmshd.log
       if not "%2" == "-quiet" call g_dos -begin_runtime called_by gms -i
       if "%OS%" == "" goto else_ii
         if "%OS%" == "Windows_9x" goto else_iv
         echo \dump | "%GMS_BINARIES%\%GMS_TSETTER%" -ini %GEROLF% 2>gmserr.log
           goto fi_ii
         :else_iv
           if not "%2" == "-quiet" goto else_v
             echo \dump | "%GMS_BINARIES%\%GMS_TSETTER%" -ini %GEROLF% > nul
             goto fi_ii
           :else_v
             echo \dump | "%GMS_BINARIES%\%GMS_TSETTER%" -ini %GEROLF%        
             goto fi_ii
       :else_ii
         if not "%2" == "-quiet" goto elseiii
           echo \dump | %GMS_BINARIES%\%GMS_TSETTER% -ini %GEROLF% > nul
           goto fi_ii
         :elseiii
           echo \dump | %GMS_BINARIES%\%GMS_TSETTER% -ini %GEROLF%
       :fi_ii
       if not "%2" == "-quiet" call g_dos -end_runtime called_by gms -i
       if not "%2" == "-quiet" echo GMS run time: %REPLY_AFTER%s >> gerolf.log
       if exist gerolf.log ren gerolf.log gms.pmt
       echo %slashline%%slashline%%slashies%> gmsft.log
       echo  %GMS_FOLDER%>> gmsft.log
     set slashline=
     set slashies=
     sed "s/(INITEX)/\n&/" < gms.pmt > gms.tmp
     if not exist gmserr.log echo.>gmserr.log
     copy gmshd.log + gms.tmp + gmsft.log + gmserr.log gerolf.log > nul
     if exist gmshd.log del gmshd.log
     if exist gms.pmt del gms.pmt
     if exist gms.tmp del gms.tmp
     if exist gmserr.log del gmserr.log
     if exist gmsft.log del gmsft.log
     REM Move .log and .enc files to appropriate locations:
     set logf=gerolf.log
       if "%OS%" == "" if exist %logf% copy %logf% %GMS_SETTING% > nul
       if not "%OS%" == "" if exist %logf% copy %logf% "%GMS_SETTING%" > nul
       if exist %logf% del %logf%
     set logf=
     REM if exist *.enc copy *.enc %GMS_ROOT%\data\enc > nul
     if "%OS%" == "" if exist *.enc copy *.enc %GMS_ROOT%\data\enc > nul
     if not "%OS%" == "" if exist *.enc copy *.enc "%GMS_ROOT%\data\enc" > nul
     if exist *.enc del *.enc
     if exist *.lst del *.lst
     if not "%2" == "-quiet" if "%GMS_FreeDOS%" == "" mode con lines=25 > nul
     if not "%2" == "-quiet" if not "%GMS_FreeDOS%" == "" mode co80,25
     if not "%2" == "-quiet" echo. %GMS_FILE%
     if "%OS%" == "" if not "%2" == "-quiet" type %GMS_SETTING%\desktop.scn
   if not "%OS%" == "" if not "%2" == "-quiet" type "%GMS_SETTING%\desktop.scn"
     if not "%2" == "-quiet" echo. %GMS_SETTING%   
   set TEXINPUTS=
   set WEB2C=
   set GMS_FOLDER=%GMS_SETTING%
   set GEROLF=
   call g_dos -chdir called_by gms -i
   call g_plug -remove called_by gms -i
   goto then_x
 :fi_i
     
 REM Read output file: --------------------------------------------------------

 if (%1) == (-r) goto then_r
 if (%1) == (-R) goto then_r
 if (%1) == (--r) goto then_r
 if (%1) == (--R) goto then_r
 if (%1) == (/r) goto then_r
 if (%1) == (/R) goto then_r
 if (%1) == (r) goto then_r
 if (%1) == (R) goto then_r
 if (%1) == (rr) goto then_r
 if not (%1) == (RR) goto fi_r
 :then_r
   if "%GMS_FILE%" == "_folder.err" goto help
   set backup_file=%GMS_FILE%
   set GMS_FILE=%GMS_BASE%.pdf
   set GMS_PROGRAM=portable document file reader
   set GMS_COMMAND=%GMS_READER%
   cls
   if "%GMS_FreeDOS%" == "" mode con lines=25 > nul
   if not "%GMS_FreeDOS%" == "" mode co80,25
   if not "%2" == "-quiet" echo  %GMS_FILE% - Running %GMS_PROGRAM% ...
   if "%OS%" == "" if not "%2" == "-quiet" type %GMS_SETTING%\desktop.scn
   if not "%OS%" == "" if not "%2" == "-quiet" type "%GMS_SETTING%\desktop.scn"
   if not "%2" == "-quiet" echo. %GMS_FOLDER%
   goto then_x
 :fi_r

 REM Learn: -------------------------------------------------------------------

 if (%1) == (-l) goto then_l
 if (%1) == (-L) goto then_l
 if (%1) == (--l) goto then_l
 if (%1) == (--L) goto then_l
 if (%1) == (/l) goto then_l
 if (%1) == (/L) goto then_l
 if (%1) == (l) goto then_l
 if (%1) == (L) goto then_l
 if (%1) == (ll) goto then_l
 if not (%1) == (LL) goto fi_l
 :then_l
   set GMS_MESSAGE=handbook.htm                The
   set GMS_MESSAGE=%GMS_MESSAGE% Gerolf Markup Shredder Handbook
   set GMS_REMODRV=%GMS_DRIVE%
   %GMS_REMODRV%
   set GMS_FOLDER=%GMS_TEMPLATE%\handbook
   set GMS_FILE=handbook.htm
   set GMS_SHORT=handbook.htm
   set GMS_BASE=handbook
   call g_dos -chdir called_by gms -l
   goto help
 :fi_l

 REM Select: ------------------------------------------------------------------

 if (%1) == (-s) goto then_s
 if (%1) == (-S) goto then_s
 if (%1) == (--s) goto then_s
 if (%1) == (--S) goto then_s
 if (%1) == (/s) goto then_s
 if (%1) == (/S) goto then_s
 if (%1) == (s) goto then_s
 if (%1) == (S) goto then_s
 if (%1) == (ss) goto then_s
 if not (%1) == (SS) goto fi_s
 :then_s
   set GMS_MESSAGE= gerolf: The GMS launcher script. Here
   set GMS_MESSAGE=%GMS_MESSAGE% you can edit the programs
   set GMS_MESSAGE=%GMS_MESSAGE% to use via GMS
   set GMS_REMODRV=%GMS_DRIVE%
   %GMS_REMODRV%
   set GMS_FOLDER=%GMS_SETTING%
   call g_dos -chdir called_by gms -s
   set GMS_FILE=gerolf.bat
   set GMS_SHORT=gerolf.bat
   set GMS_BASE=gerolf
   goto help
 :fi_s 

 REM Write font map: ----------------------------------------------------------

 if (%1) == (-w) goto then_w
 if (%1) == (-W) goto then_w
 if (%1) == (--w) goto then_w
 if (%1) == (--W) goto then_w
 if (%1) == (/w) goto then_w
 if (%1) == (/W) goto then_w
 if (%1) == (w) goto then_w
 if (%1) == (W) goto then_w
 if (%1) == (ww) goto then_w
 if not (%1) == (WW) goto fi_w
 REM %2: empty or "-quiet"
 :then_w
   set backup_folder=%GMS_FOLDER%
   set backup_file=%GMS_FILE%
   set backup_base=%GMS_BASE%
   set backup_short=%GMS_SHORT%
   set GMS_FOLDER=%GMS_SETTING%
   set GMS_FILE=font.map
   set GMS_BASE=font
   set GMS_SHORT=font.map
   set GMS_COMMAND=%GMS_VIEWER%
   set GMS_PROGRAM=font installer
   set GMS_NOREMO=1
   %GMS_DRIVE%
   call g_dos -chdir called_by gms -w
   if not "%2" == "-quiet" if "%GMS_FreeDOS%" == "" mode con lines=25 > nul
   if not "%2" == "-quiet" if not "%GMS_FreeDOS%" == "" mode co80,25
   if not "%2" == "-quiet" echo. %GMS_FILE%
   if "%OS%" == "" if not "%2" == "-quiet" type %GMS_SETTING%\desktop.scn
   if not "%OS%" == "" if not "%2" == "-quiet" type "%GMS_SETTING%\desktop.scn"
   if not "%2" == "-quiet" echo. %GMS_FOLDER%
   if not "%2" == "-quiet" call g_dos -begin_runtime called_by gms -w
     if "%OS%" == "" goto else_w1
     if "%OS%" == "Windows_9x" goto else_w1
       call g_font -build_all %2 2> gmserr.log
       goto fi_w1
     :else_w1
       call g_font -build_all %2
     :fi_w1
   set slashline=////////////////////////////////////////////////////////////
   if "%OS%" == "Windows_9x" set slashline=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
   if "%winbootdir%" == "." set slashies=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
   set slashies=////////////////////
   if "%OS%" == "Windows_9x" set slashies=XXXXXXXXXXXXXXXXXXXX
   if "%winbootdir%" == "." set slashies=XXXXXXXXXXXXXXXXXXXX
   if not "%2" == "-quiet" call g_dos -end_runtime called_by gms -w
   if not "%2" == "-quiet" echo.>> font.map 
   if not "%2" == "-quiet" echo %% GMS run time: %REPLY_AFTER%s>> font.map
   echo.>> font.map
   if "%OS%" == "" goto fi_w2
     echo %% Warnings, errors, missing glyph list: see font.log>>font.map
     echo.>> font.map
     echo %% %slashline%%slashline%%slashies%>> font.map
   :fi_w2
   echo %% %GMS_FOLDER%>>font.map
   if not exist gmserr.log echo.>gmserr.log
   sed "/^$/d; s/^/%% /; s/^ %% $//" < gmserr.log >> font.log
   if exist gmserr.log del gmserr.log
   if "%GMS_DRDOS%" == "" echo %% %slashline%%slashline%>> font.log
   echo %% %GMS_FOLDER%>> font.log
   set slashline=
   set slashies=
   goto then_x
 :fi_w

 REM Execute command: ---------------------------------------------------------

 if not (%1) == (-execute) goto fi_x
 :then_x
   if "%GMS_FILE%" == "" goto else_x1
   if "%OS%" == "" if not exist %GMS_FOLDER%\%GMS_FILE% goto else_x1 
   if not "%OS%" == "" if not exist "%GMS_FOLDER%\%GMS_FILE%" goto else_x1
     if "%GMS_MODE%" == "quiet" goto fi_x2
     if "%2" == "-quiet" goto fi_x2
       if not "%GMS_COMMAND%" == "%GMS_VIEWER%" goto else_x2
     REM Contribute to gmsdebug.log:
       if not %GMS_DEBUG% == Z goto fi_x21
       if "%OS%" == "" goto fi_x21
         echo   GMS_COMMAND=%GMS_COMMAND%>> %Z%
         echo   GMS_SHORT=%GMS_SHORT%>> %Z%
       :fi_x21
     REM Change codepage, color, line mode; run viewer:
       if not "%OS%" == "" if not "%OS%" == "Windows_9x" color F7
       cls
       echo.
       if not "%OS%" == "" chcp %GMS_CHCP% > nul
       cls
       if not "%OS%" == "" if not "%OS%" == "Windows_9x" color F0
       if "%GMS_FreeDOS%" == "" mode con lines=50 > nul
       if not "%GMS_FreeDOS%" == "" mode co80,50
       cls
         if "%GMS_NOREMO%" == "" set GMS_ACTDRV=%GMS_REMODRV%
         if not "%GMS_NOREMO%" == "" set GMS_ACTDRV=%GMS_DRIVE%
           %GMS_ACTDRV%
           browse %GMS_SHORT%
           %GMS_REMODRV%
         set GMS_NOREMO=
         set GMS_ACTDRV=
       cls
       if not "%OS%" == "" if not "%OS%" == "Windows_9x" color F7
       cls
       echo.
       if not "%OS%" == "" chcp %GMS_INICP% > nul
       cls
       if "%GMS_FreeDOS%" == "" mode con lines=25 > nul
       if not "%GMS_FreeDOS%" == "" mode co80,25
       if not "%2" == "-quiet" echo. %GMS_FILE%
       if "%OS%" == "" if not "%2" == "-quiet" type %GMS_SETTING%\desktop.scn
   if not "%OS%" == "" if not "%2" == "-quiet" type "%GMS_SETTING%\desktop.scn"
       if not "%2" == "-quiet" echo. %GMS_FOLDER%
       if not "%OS%" == "" if not "%OS%" == "Windows_9x" color 07
       goto fi_x2 
     :else_x2
       if "%GMS_FreeDOS%" == "" mode con lines=25 > nul
       if not "%GMS_FreeDOS%" == "" mode co80,25
       if not "%2" == "-quiet" echo. %GMS_FILE% - Running %GMS_PROGRAM% ...
       if "%OS%" == "" if not "%2" == "-quiet" type %GMS_SETTING%\desktop.scn
   if not "%OS%" == "" if not "%2" == "-quiet" type "%GMS_SETTING%\desktop.scn"
       if not "%2" == "-quiet" echo. %GMS_FOLDER%
      REM Contribute to gmsdebug.log:
       if not %GMS_DEBUG% == Z goto fi_x22
       if "%OS%" == "" goto fi_x22
         echo   GMS_COMMAND=%GMS_COMMAND%>> %Z%
         echo   GMS_REMODRV=%GMS_REMODRV%>> %Z%
         echo   GMS_FOLDER=%GMS_FOLDER%>> %Z%
         echo   GMS_FILE=%GMS_FILE%>> %Z%
       :fi_x22
      REM Execute command:
       if "%GMS_COMMAND%" == "default" set GMS_COMMAND=
       %GMS_REMODRV%
       if "%OS%" == "" if not "%GMS_FOLDER%" == "" cd %GMS_FOLDER%>nul
       if not "%OS%" == "" if not "%GMS_FOLDER%" == "" cd "%GMS_FOLDER%">nul
       if "%OS%" == "" call %GMS_COMMAND% %GMS_FOLDER%\%GMS_FILE%
       if not "%OS%" == "" call %GMS_COMMAND% "%GMS_FOLDER%\%GMS_FILE%"				
       if "%GMS_FreeDOS%" == "" mode con lines=25 > nul
       if not "%GMS_FreeDOS%" == "" mode co80,25
       if not "%2" == "-quiet" echo. %GMS_FILE% - Running %GMS_PROGRAM% ...
       if "%OS%" == "" if not "%2" == "-quiet" type %GMS_SETTING%\desktop.scn
   if not "%OS%" == "" if not "%2" == "-quiet" type "%GMS_SETTING%\desktop.scn"
       if not "%2" == "-quiet" echo. %GMS_FOLDER%
     :fi_x2
     goto fi_x1
   :else_x1
     cls
     echo  %GMS_FILE% - GMS error: File not found
     if "%OS%" == "" type %GMS_SETTING%\desktop.scn
     if not "%OS%" == "" type "%GMS_SETTING%\desktop.scn"
     echo  %GMS_FOLDER%
     if "%OS%" == "" goto fi_x11
       set mymsg= GMS error: File not found
       if %GMS_DEBUG% == Z echo %mymsg% (%GMS_FOLDER%\%GMS_FILE%).>> %Z%
       set mymsg=
     :fi_x11
     reply -sleep
   :fi_x1
   set GMS_COMMAND=
   set GMS_PROGRAM=
   if not "%backup_short%" == "" set GMS_SHORT=%backup_short%
   if not "%backup_base%" == "" set GMS_BASE=%backup_base%
   if not "%backup_file%" == "" set GMS_FILE=%backup_file%
   if not "%backup_folder%" == "" set GMS_FOLDER=%backup_folder%
   if not "%backup_folder%" == "" call g_dos -chdir called_by gms -execute
   set backup_short=
   set backup_base=
   set backup_file=
   set backup_folder=
   goto help
 :fi_x

 REM Show error: --------------------------------------------------------------

 :else
   if "%OS%" == "" if exist %GMS_FOLDER%\%GMS_FILE% goto fi
   if not "%OS%" == "" if exist "%GMS_FOLDER%\%GMS_FILE%" goto fi
     set GMS_MESSAGE=GMS error: No file or command line option %1
     reply -sleep
     if "%OS%" == "" goto exit
   if %GMS_DEBUG% == Z echo GMS error: No file or command line option %1>>%Z%
   goto exit
 :fi

 REM Epilogue: ================================================================

 :help
   if "%2" == "-quiet" goto exit  
   if not "%GMS_TEXTMODE%" == "" goto exit
     cls
   if (%GMS_FILE%) == () echo  GMS: No markup file opened.
   if not (%GMS_FILE%) == () echo  %GMS_FILE%
   if "%OS%" == "" type %GMS_SETTING%\menu.scn
   if not "%OS%" == "" type "%GMS_SETTING%\menu.scn"
 :exit
