 REM g_select.bat
 REM ============

 REM This file is part of Gerolf Markup Shredder,
 REM written by G. D. Brettschneider (1999-2006).

 REM set GMSdateG_select=20060927

 REM Prologue: ================================================================

 REM Not running:

 if not "%GMS_BATCH%" == "" goto fi_nr
   echo  G e r o l f   M a r k u p   S h r e d d e r   (g_select)   . . .
   pause > nul
   gerolf 2> nul
   goto exit
 :fi_nr

 REM Debug: -------------------------------------------------------------------

 if "%OS%" == "" goto fi_db
 if -%GMS_DEBUG% == - goto fi_db
 if %GMS_DEBUG% == Z echo %0 (%1) (%2) (%3) (%4) (%5) (%6) (%7) (%8)>> %Z%
 if %GMS_DEBUG% == X goto then_db
 if not %GMS_DEBUG% == Y goto fi_db
 :then_db
   call l_banner -debug g_select %1 %2 %3 %4
 :fi_db

 REM Chapters: ================================================================

 REM Not defined:

 if not "%1" == "" goto fi_nd
   call l_banner -no_action g_select
   goto exit
 :fi_nd

 REM Resize: ------------------------------------------------------------------
 
 if %1 == -update goto then_rs
 if %1 == -resize goto then_rs
 if %1 == -build goto then_rs
 if not %1 == -remove goto fi_rs
 :then_rs
   set REPLY_OFFSET=3
   set REPLY_SIZE=17
   set REPLY_ITEMS=8
   if %1 == -update goto then_u
   if %1 == -build goto then_b
   if %1 == -remove goto then_r
   goto exit
 :fi_rs

 REM Build: -------------------------------------------------------------------

 if not %1 == -build goto fi_b
 :then_b
   call l_banner -lower -select called_by g_select %1
   call l_box -t11_build called_by g_select %1
   if not %GMS_ANIMATE% == on goto else_b1
     call l_select -build off called_by g_select %1
     goto fi_b1
   :else_b1
     call l_select -build on called_by g_select %1
   :fi_b1
   set GMS_HOT=Q
   call l_select -update Q Q called_by g_select %1
   set REPLY_MODULE=g_select
   set REPLY_ACTION=-update
   set GMS_RECEIVE=1
   goto exit
 :fi_b

 REM Remove: ------------------------------------------------------------------

 if not %1 == -remove goto fi_r
 :then_r
   call l_box -t11_remove called_by g_select %1
   goto exit
 :fi_r

 REM Update: ------------------------------------------------------------------

 if not %1 == -update goto fi_u
 :then_u
 REM Cold:
   if not "%3" == "" goto else_u1
     set GMS_COLD=%GMS_HOT%
     goto fi_u1
   :else_u1
     set GMS_COLD=%3
   :fi_u1
 REM Hot:
   if not "%2" == "" goto else_u2
     call l_banner -no_hot g_select called_by g_select %1
     goto fi_u2
   :else_u2
     set GMS_HOT=Q
     if %2 == A set GMS_HOT=A
     if %2 == a set GMS_HOT=A
     if %2 == 2 set GMS_HOT=A
     if %2 == C set GMS_HOT=C
     if %2 == c set GMS_HOT=C
     if %2 == 3 set GMS_HOT=C
     if %2 == P set GMS_HOT=P
     if %2 == p set GMS_HOT=P
     if %2 == 4 set GMS_HOT=P
     if %2 == D set GMS_HOT=D
     if %2 == d set GMS_HOT=D
     if %2 == 5 set GMS_HOT=D
     if %2 == X set GMS_HOT=D
     if %2 == x set GMS_HOT=D
     if %2 == 0 set GMS_HOT=D
     if %2 == Y set GMS_HOT=D
     if %2 == y set GMS_HOT=D
     if %2 == o set GMS_HOT=D
     if %2 == E set GMS_HOT=E
     if %2 == e set GMS_HOT=E
     if %2 == 6 set GMS_HOT=E
     if %2 == I set GMS_HOT=E
     if %2 == i set GMS_HOT=E
     if %2 == U set GMS_HOT=U
     if %2 == u set GMS_HOT=U
     if %2 == 7 set GMS_HOT=U
     if %2 == L set GMS_HOT=L
     if %2 == l set GMS_HOT=L
     if %2 == 8 set GMS_HOT=L
   :fi_u2
 REM Handle old, update new:
   if not %GMS_HOT% == %GMS_COLD% goto else_u3
     goto then_h
   :else_u3
   REM Banner:
     if %GMS_HOT% == Q call l_banner -lower -first called_by g_select %1
     if %GMS_HOT% == A call l_banner -lower -animate called_by g_select %1
     if %GMS_HOT% == U call l_banner -lower -codepage called_by g_select %1
     if %GMS_HOT% == L call l_banner -lower -codepage called_by g_select %1
     if %GMS_HOT% == C call l_banner -lower -select called_by g_select %1
     if %GMS_HOT% == P call l_banner -lower -select called_by g_select %1
     if %GMS_HOT% == D call l_banner -lower -select called_by g_select %1
     if %GMS_HOT% == E call l_banner -lower -select called_by g_select %1
   REM Debugging:
     if "%4" == "" goto fi_u4
     if not %GMS_COLD% == D goto fi_u4
       if %4 == X set GMS_DEBUG=X
       if %4 == x set GMS_DEBUG=X
       if %4 == Y set GMS_DEBUG=Y
       if %4 == y set GMS_DEBUG=Y
       if %4 == z set GMS_DEBUG=Z
       if %4 == Z set GMS_DEBUG=Z
       if %4 == O set GMS_DEBUG=0
       if %4 == o set GMS_DEBUG=0
       if %4 == 0 set GMS_DEBUG=0
       if %4 == O goto then_u44
       if %4 == o goto then_u44
       if not %4 == 0 goto fi_u44
       :then_u44
         REM Remove debug banners:
           set backup_offset=%REPLY_OFFSET%
             set backup_size=%REPLY_SIZE%
               set REPLY_OFFSET=0
                 set REPLY_SIZE=78
                   reply -stripe 2 %REPLY_PATTERN% %REPLY_LETTER%
                   reply -stripe 23 %REPLY_PATTERN% %REPLY_LETTER%
                 set REPLY_SIZE=%backup_size%
               set REPLY_OFFSET=%backup_offset%
             set backup_size=
           set backup_offset=
           call g_select -resize called_by g_select %1
       :fi_u44
       if -%GMS_DEBUG% == -Z set Z=nul
       call g_launch -build called_by g_select %1
     :fi_u4
   REM Encoding:
     if "%4" == "" goto fi_u5
     if not %GMS_COLD% == E goto fi_u5
       set GMS_CODEPAGE=%4
     REM Normalize writing:
       if %4 == ARABIC set GMS_CODEPAGE=CP1256
       if %4 == Arabic set GMS_CODEPAGE=CP1256
       if %4 == arabic set GMS_CODEPAGE=CP1256
       if %4 == ARABICBH set GMS_CODEPAGE=CP1256
       if %4 == ArabicBH set GMS_CODEPAGE=CP1256
       if %4 == arabicbh set GMS_CODEPAGE=CP1256
       if %4 == ARABICMT set GMS_CODEPAGE=CP1256
       if %4 == ArabicMT set GMS_CODEPAGE=CP1256
       if %4 == arabicmt set GMS_CODEPAGE=CP1256
       if %4 == ASCII set GMS_CODEPAGE=US-ASCII
       if %4 == Ascii set GMS_CODEPAGE=US-ASCII
       if %4 == ascii set GMS_CODEPAGE=US-ASCII
       if %4 == BALTIC set GMS_CODEPAGE=CP1257
       if %4 == Baltic set GMS_CODEPAGE=CP1257
       if %4 == baltic set GMS_CODEPAGE=CP1257
       if %4 == CANADA set GMS_CODEPAGE=CP863
       if %4 == Canada set GMS_CODEPAGE=CP863
       if %4 == canada set GMS_CODEPAGE=CP863
       if %4 == CENTRAL set GMS_CODEPAGE=CP1250
       if %4 == Central set GMS_CODEPAGE=CP1250
       if %4 == central set GMS_CODEPAGE=CP1250
       if %4 == cp437 set GMS_CODEPAGE=CP437
       if %4 == cp850 set GMS_CODEPAGE=CP850
       if %4 == cp860 set GMS_CODEPAGE=CP860
       if %4 == cp863 set GMS_CODEPAGE=CP863
       if %4 == cp865 set GMS_CODEPAGE=CP865
       if %4 == cp874 set GMS_CODEPAGE=CP874
       if %4 == cp1250 set GMS_CODEPAGE=CP1250
       if %4 == cp1251 set GMS_CODEPAGE=CP1251
       if %4 == cp1252 set GMS_CODEPAGE=CP1252
       if %4 == cp1253 set GMS_CODEPAGE=CP1253
       if %4 == cp1254 set GMS_CODEPAGE=CP1254
       if %4 == cp1255 set GMS_CODEPAGE=CP1255
       if %4 == cp1256 set GMS_CODEPAGE=CP1256
       if %4 == cp1257 set GMS_CODEPAGE=CP1257
       if %4 == cp1258 set GMS_CODEPAGE=CP1258
       if %4 == CYRILLIC set GMS_CODEPAGE=CP1251
       if %4 == Cyrillic set GMS_CODEPAGE=CP1251
       if %4 == cyrillic set GMS_CODEPAGE=CP1251
       if %4 == GREEK set GMS_CODEPAGE=CP1253
       if %4 == Greek set GMS_CODEPAGE=CP1253
       if %4 == greek set GMS_CODEPAGE=CP1253
       if %4 == HEBREW set GMS_CODEPAGE=CP1255
       if %4 == Hebrew set GMS_CODEPAGE=CP1255
       if %4 == hebrew set GMS_CODEPAGE=CP1255
       if %4 == INDIAN set GMS_CODEPAGE=ISCII
       if %4 == Indian set GMS_CODEPAGE=ISCII
       if %4 == indian set GMS_CODEPAGE=ISCII
       if %4 == Iscii set GMS_CODEPAGE=ISCII
       if %4 == iscii set GMS_CODEPAGE=ISCII
       if %4 == ISO-646 set GMS_CODEPAGE=ISO646
       if %4 == ISO_646 set GMS_CODEPAGE=ISO646
       if %4 == iso-646 set GMS_CODEPAGE=ISO646
       if %4 == iso_646 set GMS_CODEPAGE=ISO646
       if %4 == iso646 set GMS_CODEPAGE=ISO646
       if %4 == ISO-8859-1 set GMS_CODEPAGE=I8859-1
       if %4 == ISO_8859-1 set GMS_CODEPAGE=I8859-1
       if %4 == iso-8859-1 set GMS_CODEPAGE=I8859-1
       if %4 == iso_8859-1 set GMS_CODEPAGE=I8859-1
       if %4 == ISO-8859-2 set GMS_CODEPAGE=I8859-2
       if %4 == ISO_8859-2 set GMS_CODEPAGE=I8859-2
       if %4 == iso-8859-2 set GMS_CODEPAGE=I8859-2
       if %4 == iso_8859-2 set GMS_CODEPAGE=I8859-2
       if %4 == ISO-8859-3 set GMS_CODEPAGE=I8859-3
       if %4 == ISO_8859-3 set GMS_CODEPAGE=I8859-3
       if %4 == iso-8859-3 set GMS_CODEPAGE=I8859-3
       if %4 == iso_8859-3 set GMS_CODEPAGE=I8859-3
       if %4 == ISO-8859-4 set GMS_CODEPAGE=I8859-4
       if %4 == ISO_8859-4 set GMS_CODEPAGE=I8859-4
       if %4 == iso-8859-4 set GMS_CODEPAGE=I8859-4
       if %4 == iso_8859-4 set GMS_CODEPAGE=I8859-4
       if %4 == ISO-8859-5 set GMS_CODEPAGE=I8859-5
       if %4 == ISO_8859-5 set GMS_CODEPAGE=I8859-5
       if %4 == iso-8859-5 set GMS_CODEPAGE=I8859-5
       if %4 == iso_8859-5 set GMS_CODEPAGE=I8859-5
       if %4 == ISO-8859-6 set GMS_CODEPAGE=I8859-6
       if %4 == ISO_8859-6 set GMS_CODEPAGE=I8859-6
       if %4 == iso-8859-6 set GMS_CODEPAGE=I8859-6
       if %4 == iso_8859-6 set GMS_CODEPAGE=I8859-6
       if %4 == ISO-8859-7 set GMS_CODEPAGE=I8859-7
       if %4 == ISO_8859-7 set GMS_CODEPAGE=I8859-7
       if %4 == iso-8859-7 set GMS_CODEPAGE=I8859-7
       if %4 == iso_8859-7 set GMS_CODEPAGE=I8859-7
       if %4 == ISO-8859-8 set GMS_CODEPAGE=I8859-8
       if %4 == ISO_8859-8 set GMS_CODEPAGE=I8859-8
       if %4 == iso-8859-8 set GMS_CODEPAGE=I8859-8
       if %4 == iso_8859-8 set GMS_CODEPAGE=I8859-8
       if %4 == ISO-8859-9 set GMS_CODEPAGE=I8859-9
       if %4 == ISO_8859-9 set GMS_CODEPAGE=I8859-9
       if %4 == iso-8859-9 set GMS_CODEPAGE=I8859-9
       if %4 == iso_8859-9 set GMS_CODEPAGE=I8859-9
       if %4 == ISO-8859-10 set GMS_CODEPAGE=I8859-10
       if %4 == ISO_8859-10 set GMS_CODEPAGE=I8859-10
       if %4 == iso-8859-10 set GMS_CODEPAGE=I8859-10
       if %4 == iso_8859-10 set GMS_CODEPAGE=I8859-10
       if %4 == ISO-8859-11 set GMS_CODEPAGE=I8859-11
       if %4 == ISO_8859-11 set GMS_CODEPAGE=I8859-11
       if %4 == iso-8859-11 set GMS_CODEPAGE=I8859-11
       if %4 == iso_8859-11 set GMS_CODEPAGE=I8859-11
       if %4 == ISO-8859-13 set GMS_CODEPAGE=I8859-13
       if %4 == ISO_8859-13 set GMS_CODEPAGE=I8859-13
       if %4 == iso-8859-13 set GMS_CODEPAGE=I8859-13
       if %4 == iso_8859-13 set GMS_CODEPAGE=I8859-13
       if %4 == ISO-8859-14 set GMS_CODEPAGE=I8859-14
       if %4 == ISO_8859-14 set GMS_CODEPAGE=I8859-14
       if %4 == iso-8859-14 set GMS_CODEPAGE=I8859-14
       if %4 == iso_8859-14 set GMS_CODEPAGE=I8859-14
       if %4 == ISO-8859-15 set GMS_CODEPAGE=I8859-15
       if %4 == ISO_8859-15 set GMS_CODEPAGE=I8859-15
       if %4 == iso-8859-15 set GMS_CODEPAGE=I8859-15
       if %4 == iso_8859-15 set GMS_CODEPAGE=I8859-15
       if %4 == LATIN set GMS_CODEPAGE=CP1252
       if %4 == Latin set GMS_CODEPAGE=CP1252
       if %4 == latin set GMS_CODEPAGE=CP1252
       if %4 == LATIN-1 set GMS_CODEPAGE=CP1252
       if %4 == Latin-1 set GMS_CODEPAGE=CP1252
       if %4 == latin-1 set GMS_CODEPAGE=CP1252
       if %4 == LATIN-2 set GMS_CODEPAGE=CP1250
       if %4 == Latin-2 set GMS_CODEPAGE=CP1250
       if %4 == latin-2 set GMS_CODEPAGE=CP1250
       if %4 == LATIN-5 set GMS_CODEPAGE=CP1254
       if %4 == Latin-5 set GMS_CODEPAGE=CP1254
       if %4 == latin-5 set GMS_CODEPAGE=CP1254
       if %4 == MULTILINGUAL set GMS_CODEPAGE=CP850
       if %4 == Multilingual set GMS_CODEPAGE=CP850
       if %4 == multilingual set GMS_CODEPAGE=CP850
       if %4 == NORWAY set GMS_CODEPAGE=CP865
       if %4 == Norway set GMS_CODEPAGE=CP865
       if %4 == norway set GMS_CODEPAGE=CP865
       if %4 == PORTUGAL set GMS_CODEPAGE=CP860
       if %4 == Portugal set GMS_CODEPAGE=CP860
       if %4 == portugal set GMS_CODEPAGE=CP860
       if %4 == THAI set GMS_CODEPAGE=CP874
       if %4 == Thai set GMS_CODEPAGE=CP874
       if %4 == thai set GMS_CODEPAGE=CP874
       if %4 == TURKISH set GMS_CODEPAGE=CP1254
       if %4 == Turkish set GMS_CODEPAGE=CP1254
       if %4 == turkish set GMS_CODEPAGE=CP1254
       if %4 == USA set GMS_CODEPAGE=CP437
       if %4 == Usa set GMS_CODEPAGE=CP437
       if %4 == usa set GMS_CODEPAGE=CP437
       if %4 == US_ASCII set GMS_CODEPAGE=US-ASCII
       if %4 == Us_ascii set GMS_CODEPAGE=US-ASCII
       if %4 == us_ascii set GMS_CODEPAGE=US-ASCII
       if %4 == Us-ascii set GMS_CODEPAGE=US-ASCII
       if %4 == us-ascii set GMS_CODEPAGE=US-ASCII
       if %4 == VIETNAM set GMS_CODEPAGE=VISCII
       if %4 == Vietnam set GMS_CODEPAGE=VISCII
       if %4 == vietnam set GMS_CODEPAGE=VISCII
       if %4 == VIETNAMESE set GMS_CODEPAGE=VISCII
       if %4 == Vietnamese set GMS_CODEPAGE=VISCII
       if %4 == vietnamese set GMS_CODEPAGE=VISCII
       if %4 == Viscii set GMS_CODEPAGE=VISCII
       if %4 == viscii set GMS_CODEPAGE=VISCII
       if %4 == WESTERN set GMS_CODEPAGE=CP1252
       if %4 == Western set GMS_CODEPAGE=CP1252
       if %4 == western set GMS_CODEPAGE=CP1252
       if %4 == WINDOWS-1250 set GMS_CODEPAGE=CP1250
       if %4 == windows-1250 set GMS_CODEPAGE=CP1250
       if %4 == WINDOWS-1251 set GMS_CODEPAGE=CP1251
       if %4 == windows-1251 set GMS_CODEPAGE=CP1251
       if %4 == WINDOWS-1252 set GMS_CODEPAGE=CP1252
       if %4 == windows-1252 set GMS_CODEPAGE=CP1252
       if %4 == WINDOWS-1253 set GMS_CODEPAGE=CP1253
       if %4 == windows-1253 set GMS_CODEPAGE=CP1253
       if %4 == WINDOWS-1254 set GMS_CODEPAGE=CP1254
       if %4 == windows-1254 set GMS_CODEPAGE=CP1254
       if %4 == WINDOWS-1255 set GMS_CODEPAGE=CP1255
       if %4 == windows-1255 set GMS_CODEPAGE=CP1255
       if %4 == WINDOWS-1256 set GMS_CODEPAGE=CP1256
       if %4 == windows-1256 set GMS_CODEPAGE=CP1256
       if %4 == WINDOWS-1257 set GMS_CODEPAGE=CP1257
       if %4 == windows-1257 set GMS_CODEPAGE=CP1257
       if %4 == WINDOWS-1258 set GMS_CODEPAGE=CP1258
       if %4 == windows-1258 set GMS_CODEPAGE=CP1258
       call g_launch -build called_by g_select %1
     :fi_u5
   REM Select:
     if not %GMS_ANIMATE% == on goto else_u6
       set arg=%GMS_HOT% %GMS_COLD% off
       call l_select -update %arg% called_by g_select %1
       goto fi_u6
     :else_u6 
       set arg=%GMS_HOT% %GMS_COLD% on
       call l_select -update %arg% called_by g_select %1
     :fi_u6
     set arg=
   :fi_u3
   set GMS_RECEIVE=1
   goto exit
 :fi_u

 REM Handle: ------------------------------------------------------------------

 if not %1 == -handle goto fi_h
 :then_h

 REM Quit:
   if not %GMS_HOT% == Q goto fi_hq
     call l_banner -lower -folder called_by g_select %1 Q
     call g_select -remove called_by g_select %1 Q
     call g_menu -update S Q called_by g_select %1 Q
     set REPLY_MODULE=g_menu
     set REPLY_ACTION=-update
     goto exit
   :fi_hq

 REM Animation:
   if not %GMS_HOT% == A goto fi_ha
     if not %GMS_ANIMATE% == on goto else_ha1
       set GMS_ANIMATE=off
       goto fi_ha1
     :else_ha1
       set GMS_ANIMATE=on
     :fi_ha1
     call g_launch -build called_by g_select %1 A
     call g_select -update A Q called_by g_select %1 A
     set REPLY_MODULE=g_select
     set REPLY_ACTION=-update
     goto exit
   :fi_ha

 REM Color:
   if not %GMS_HOT% == C goto fi_hc
     call l_select -update - C called_by g_select -handle C
     call l_select -update - P called_by g_select -handle C
     call g_select -remove called_by g_select %1 C
     call g_rain -build called_by g_select %1 C
     call g_color -build called_by g_select %1 C
     goto exit
   :fi_hc

 REM Programs:
   if not %GMS_HOT% == P goto fi_hp
     call l_select -update - D called_by g_select %1 P
     call l_select -update - P called_by g_select %1 P
     call g_prog -build called_by g_select %1 P
     goto exit
   :fi_hp

 REM Debugging:
   if not %GMS_HOT% == D goto fi_hd
     set GMS_RECEIVE=1
     call l_banner -lower -debug called_by g_select %1 D
     call l_select -update - D called_by g_select %1 D
     reply -question 11 %GMS_DEBUG% DD 5 
     goto exit
   :fi_hd

 REM Encoding:
   if not %GMS_HOT% == E goto fi_he
     set GMS_RECEIVE=1
     call l_banner -lower -encode called_by g_select %1 E
     call l_select -update - E called_by g_select %1 E
     reply -question 13 %GMS_CODEPAGE% EE 6
     goto exit
   :fi_he

 REM Codepage (upper half):
   if not %GMS_HOT% == U goto fi_hu   :then_hu
     call g_code -cp_up_build called_by g_select %1 U
     goto exit
   :fi_hu

 REM Codepage (lower half):
   if not %GMS_HOT% == L goto fi_hl
     call g_code -cp_lo_build called_by g_select %1 L
     goto exit
   :fi_hl

 REM Not found:
   :else_h
     call l_banner -no_hotkey g_select %2
     goto exit 
   :fi_h

 REM Not found: ---------------------------------------------------------------

 :else
   call l_banner -no_action g_select %1
 :fi

 :exit
