 REM g_prog.bat
 REM ==========

 REM This file is part of Gerolf Markup Shredder,
 REM written by G. D. Brettschneider (1999-2006).

 REM set GMSdateG_PROG=20060927

 REM Prologue: ================================================================

 REM Not running:

 if not "%GMS_BATCH%" == "" goto fi_nr
   echo  G e r o l f   M a r k u p   S h r e d d e r   (g_prog)   . . .
   pause > nul
   gerolf 2> nul
   goto exit
 :fi_nr

 REM Debug: -------------------------------------------------------------------
 
 if "%OS%" == "" goto fi_db
 if -%GMS_DEBUG% == - goto fi_db
 if %GMS_DEBUG% == Z echo %0 (%1) (%2) (%3) (%4) (%5) (%6) (%7) (%8)>> %Z%
 if %GMS_DEBUG% == X goto then_db
 if not %GMS_DEBUG% == Y goto fi_db
 :then_db
   call l_banner -debug g_prog %1 %2 %3 %4
 :fi_db

 REM Chapters: ================================================================

 REM Not defined:

 if not "%1" == "" goto fi_nd
   call l_banner -no_action g_prog
   goto exit
 :fi_nd

 REM Resize: ------------------------------------------------------------------

 if %1 == -resize goto then_rs
 if %1 == -build goto then_rs
 if not %1 == -remove goto fi_rs
 :then_rs
   set REPLY_OFFSET=26
   set REPLY_SIZE=20
   set REPLY_ITEMS=7
   if %1 == -build goto then_b
   if %1 == -remove goto then_r
   goto exit
 :fi_rs

 REM Build: -------------------------------------------------------------------

 if not %1 == -build goto fi_b
 :then_b
   call l_banner -lower -program
   call l_box -t11_build
   call l_prog -build 
   set GMS_HOT=Q
   call l_prog -update Q Q
   set REPLY_MODULE=g_prog
   set REPLY_ACTION=-update
   set GMS_RECEIVE=1
   goto exit
 :fi_b

 REM Remove: ------------------------------------------------------------------

 if not %1 == -remove goto fi_r
 :then_r
   call l_box -t12_remove
   goto exit
 :fi_r

 REM Update: ------------------------------------------------------------------

 if not %1 == -update goto fi_u
 :then_u
 REM Cold:
   if not "%3" == "" goto else_u1
     set GMS_COLD=%GMS_HOT%
     goto fi_u1
   :else_u1
     set GMS_COLD=%3
   :fi_u1
 REM Hot:
   if not "%2" == "" goto else_u2
     call l_banner -no_hot g_prog
     goto fi_u2
   :else_u2
     set GMS_HOT=Q
     if %2 == V set GMS_HOT=V
     if %2 == v set GMS_HOT=V
     if %2 == 1 set GMS_HOT=V
     if %2 == E set GMS_HOT=E
     if %2 == e set GMS_HOT=E
     if %2 == 2 set GMS_HOT=E
     if %2 == B set GMS_HOT=B
     if %2 == b set GMS_HOT=B
     if %2 == 3 set GMS_HOT=B
     if %2 == A set GMS_HOT=A
     if %2 == a set GMS_HOT=A
     if %2 == 4 set GMS_HOT=A
     if %2 == T set GMS_HOT=T
     if %2 == t set GMS_HOT=T
     if %2 == 5 set GMS_HOT=T
     if %2 == R set GMS_HOT=R
     if %2 == r set GMS_HOT=R
     if %2 == 6 set GMS_HOT=R
   :fi_u2
 REM Handle old, update new:
   if not %GMS_HOT% == %GMS_COLD% goto else_u3
     goto then_h
   :else_u3
   REM Set programs:
     call l_banner -lower -select
     if "%4" == "" goto fi_u33
       if %GMS_COLD% == V set GMS_VIEWER=%4
       if %GMS_COLD% == E set GMS_EDITOR=%4
       if %GMS_COLD% == B set GMS_BROWSER=%4
       if %GMS_COLD% == A set GMS_ANALYST=%4
       if %GMS_COLD% == T set GMS_TSETTER=%4
       if %GMS_COLD% == R set GMS_READER=%4
     :fi_u33
   REM Normalize writing:
     if "%GMS_TSETTER%" == "" set GMS_TSETTER=pdfetex
     if %GMS_TSETTER% == PDFETEX set GMS_TSETTER=pdfetex
     if %GMS_TSETTER% == Pdfetex set GMS_TSETTER=pdfetex
     if %GMS_TSETTER% == pdfeTeX set GMS_TSETTER=pdfetex
     if %GMS_TSETTER% == PDFTEX set GMS_TSETTER=pdftex
     if %GMS_TSETTER% == Pdftex set GMS_TSETTER=pdftex
     if %GMS_TSETTER% == pdfTeX set GMS_TSETTER=pdftex
     if %GMS_TSETTER% == ETEX set GMS_TSETTER=etex
     if %GMS_TSETTER% == Etex set GMS_TSETTER=etex
     if %GMS_TSETTER% == eTeX set GMS_TSETTER=etex
     if %GMS_TSETTER% == TEX set GMS_TSETTER=tex
     if %GMS_TSETTER% == Tex set GMS_TSETTER=tex
     if %GMS_TSETTER% == TeX set GMS_TSETTER=tex
   REM Update program box:
     set arg=%GMS_HOT% %GMS_COLD%
     call l_prog -update %arg%
     set arg=
   :fi_u3
   set GMS_RECEIVE=1
   goto exit
 :fi_u

 REM Handle: ------------------------------------------------------------------

 if not %1 == -handle goto fi_h
 :then_h

 REM Quit:
   if not %GMS_HOT% == Q goto fi_hq
     call g_launch -build called_by g_prog %1 Q
     call g_prog -remove called_by g_prog %1 Q
     call g_select -update P Q called_by g_prog %1 Q
     set REPLY_MODULE=g_select
     set REPLY_ACTION=-update
     set GMS_RECEIVE=1
     goto exit
   :fi_hq

 REM Viewer:
   if not %GMS_HOT% == V goto fi_hv
     set GMS_RECEIVE=1
     call l_banner -lower -viewer
     call l_prog -update - V called_by g_prog %1 V
     reply -question 8 %GMS_VIEWER% VV 1
     goto exit
   :fi_hv

 REM Editor:
   if not %GMS_HOT% == E goto fi_he
     set GMS_RECEIVE=1
     call l_banner -lower -editor
     call l_prog -update - E called_by g_prog %1 E
     reply -question 10 %GMS_EDITOR% EE 2
     goto exit
   :fi_he

 REM Browser:
   if not %GMS_HOT% == B goto fi_hb
     set GMS_RECEIVE=1
     call l_banner -lower -browser 
     call l_prog -update - B called_by g_prog %1 B
     reply -question 12 %GMS_BROWSER% BB 3
     goto exit
   :fi_hb

 REM Analyst:
   if not %GMS_HOT% == A goto fi_ha
     set GMS_RECEIVE=1
     call l_banner -lower -analyst 
     call l_prog -update - A called_by g_prog %1 A
     reply -question 14 %GMS_ANALYST% AA 4
     goto exit
   :fi_ha

 REM Typesetter:
   if not %GMS_HOT% == T goto fi_ht
     set GMS_RECEIVE=1
     call l_banner -lower -tsetter 
     call l_prog -update - T called_by g_prog %1 T
     reply -question 16 %GMS_TSETTER% TT 5
     goto exit
   :fi_ht

 REM Reader:
   if not %GMS_HOT% == R goto fi_hr
     set GMS_RECEIVE=1
     call l_banner -lower -reader 
     call l_prog -update - R called_by g_prog %1 R
     reply -question 18 %GMS_READER% RR 6
     goto exit
   :fi_hr

 REM Not found:
   :else_h
     call l_banner -no_hotkey g_prog %2
   goto exit

   :fi_h

 REM Not found: ---------------------------------------------------------------

 :else
   call l_banner -no_action g_prog %1
 :fi

 :exit
