 REM g_font.bat
 REM ==========

 REM This file is part of Gerolf Markup Shredder,
 REM written by G. D. Brettschneider (1999-2006).

 REM set GMSdateG_FONT=20060927

 REM Prologue: ================================================================

 REM Not running:

 if not "%GMS_BATCH%" == "" goto fi_nr
   echo  G e r o l f   M a r k u p   S h r e d d e r   (g_font) . . .
   pause > nul
   gerolf 2> nul
   goto exit
 :fi_nr 

 REM Debug: -------------------------------------------------------------------

 if "%OS%" == "" goto fi_db
 if -%GMS_DEBUG% == - goto fi_db
 if %GMS_DEBUG% == Z echo %0 (%1) (%2) (%3) (%4) (%5) (%6) (%7) (%8)>> %Z%
 if %GMS_DEBUG% == X goto then_db
 if not %GMS_DEBUG% == Y goto fi_db
 :then_db
   call l_banner -debug g_font %1 %2 %3 %4
 :fi_db

 REM Chapters: ================================================================

 REM Not defined:

 if not "%1" == "" goto fi_nd
   call l_banner -no_action g_font
   goto exit
 :fi_nd
  
 REM Copy Windows True Type fonts to GMS fonts folder: ------------------------
  
 if not %1 == -copy_fonts goto fi_cf
   if "%OS%" == "" goto exit
   REM %2 supplier
   REM %3 family
   REM %4 typeface1
   REM %5 typeface2
   REM %6 typeface3
   REM %7 typeface4   
   if not exist "%GMS_FONTS%\ttf\%any%" md "%GMS_FONTS%\ttf"
   if not exist "%GMS_FONTS%\ttf\%2\%any%" md "%GMS_FONTS%\ttf\%2"
   if not exist "%GMS_FONTS%\ttf\%2\%3\%any%" md "%GMS_FONTS%\ttf\%2\%3"
   set GMS_SRC=%windir%\Fonts
   set GMS_MISS=%GMS_SETTING%\fontmiss.log
   if "%4" == "" goto fi_cf4
     if not exist "%GMS_SRC%\%4.ttf" echo   Missing: %GMS_SRC%\%4.ttf>> %Z%
     if not exist "%GMS_SRC%\%4.ttf" echo %GMS_SRC%\%4.ttf>> "%GMS_MISS%"		 
     if not exist "%GMS_SRC%\%4.ttf" goto fi_cf4
     copy "%GMS_SRC%\%4.ttf" "%GMS_FONTS%\ttf\%2\%3" > nul
   :fi_cf4
   if "%5" == "" goto fi_cf5
     if not exist "%GMS_SRC%\%5.ttf" echo   Missing: %GMS_SRC%\%5.ttf>> %Z%
     if not exist "%GMS_SRC%\%5.ttf" echo %GMS_SRC%\%5.ttf>> "%GMS_MISS%" 
     if not exist "%GMS_SRC%\%5.ttf" goto fi_cf5
     copy "%GMS_SRC%\%5.ttf" "%GMS_FONTS%\ttf\%2\%3" > nul
   :fi_cf5
   if "%6" == "" goto fi_cf6
     if not exist "%GMS_SRC%\%6.ttf" echo   Missing: %GMS_SRC%\%6.ttf>> %Z%
     if not exist "%GMS_SRC%\%6.ttf" echo %GMS_SRC%\%6.ttf>> "%GMS_MISS%" 
     if not exist "%GMS_SRC%\%6.ttf" goto fi_cf6
     copy "%GMS_SRC%\%6.ttf" "%GMS_FONTS%\ttf\%2\%3" > nul
   :fi_cf6
   if "%7" == "" goto fi_cf7
     if not exist "%GMS_SRC%\%7.ttf" echo   Missing: %GMS_SRC%\%7.ttf>> %Z%
     if not exist "%GMS_SRC%\%7.ttf" echo %GMS_SRC%\%7.ttf>> "%GMS_MISS%" 
     if not exist "%GMS_SRC%\%7.ttf" goto fi_cf7
     copy "%GMS_SRC%\%7.ttf" "%GMS_FONTS%\ttf\%2\%3" > nul
   :fi_cf7
   if exist "%GMS_FONTS%\datagly.ttf" del "%GMS_FONTS%\datagly.ttf">> %Z%
   if exist "%GMS_FONTS%\outlook.ttf" del "%GMS_FONTS%\outlook.ttf">> %Z%
   set GMS_MISS=
   set GMS_SRC=
   goto exit
 :fi_cf
 
 REM Install GMS fonts for Windows: -------------------------------------------
 
 if not %1 == -install_win goto fi_iw
   if "%OS%" == "" goto exit
   REM %2 supplier
   REM %3 family
   REM %4 typeface1
   REM %5 typeface2
   REM %6 typeface3
   REM %7 typeface4
   set GMS_TRG=%windir%\Fonts
   set GMS_INST=%GMS_SETTING%\fontinst.log
   if "%4" == "" goto fi_iw4 
     if exist "%GMS_TRG%\%4.ttf" goto fi_iw4
     if not exist "%GMS_FONTS%\ttf\%2\%3\%4.ttf" goto fi_iw4
     echo %4.ttf>> "%GMS_INST%"
     copy "%GMS_FONTS%\ttf\%2\%3\%4.ttf" "%GMS_TRG%"> nul
   :fi_iw4
   if "%5" == "" goto fi_iw5
     if exist "%GMS_TRG%\%5.ttf" goto fi_iw5
     if not exist "%GMS_FONTS%\ttf\%2\%3\%5.ttf" goto fi_iw5
     echo %5.ttf>> "%GMS_INST%"
     copy "%GMS_FONTS%\ttf\%2\%3\%5.ttf" "%GMS_TRG%"> nul
   :fi_iw5
   if "%6" == "" goto fi_iw6
     if exist "%GMS_TRG%\%6.ttf" goto fi_iw6
     if not exist "%GMS_FONTS%\ttf\%2\%3\%6.ttf" goto fi_iw6
     echo %6.ttf>> "%GMS_INST%"
     copy "%GMS_FONTS%\ttf\%2\%3\%6.ttf" "%GMS_TRG%"> nul
   :fi_iw6
   if "%7" == "" goto fi_iw7
     if exist "%GMS_TRG%\%7.ttf" goto fi_iw7
     if not exist "%GMS_FONTS%\ttf\%2\%3\%7.ttf" goto fi_iw7
     echo %7.ttf>> "%GMS_INST%"
     copy "%GMS_FONTS%\ttf\%2\%3\%7.ttf" "%GMS_TRG%"> nul
   :fi_iw7
   set GMS_TRG=
   set GMS_INST=
   goto exit
 :fi_iw 
 
 REM Copy Windows true type fonts: --------------------------------------------
  
 if not %1 == -exchange_fonts goto fi_xf
   if "%OS%" == "" goto exit
 REM  echo.
 REM  echo  Copying:      *.ttf - True Type Fonts from %windir%\Fonts ...
   REM Log file for missing fonts: ............................................
     set GMS_MISS=%GMS_SETTING%\fontmiss.log
       echo  fontmiss.log - Missing fonts in %windir%\Fonts>> "%GMS_MISS%"
     set arg=////////////////////////////////////////
     if "%OS%" == "Windows_9x" set arg=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
     if "%winbootdir%" == "." set arg=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
       echo %arg%%arg%>> "%GMS_MISS%"
       echo.>> "%GMS_MISS%"
   REM Bigelow & Holmes fonts: ................................................
     call g_font -copy_fonts bh lucon lucon
     call g_font -copy_fonts bh lsans l_10646
   REM ITC fonts: .............................................................
     call g_font -copy_fonts itc framd framd framdit
   REM Microsoft fonts: .......................................................
     call g_font -copy_fonts ms comic comic comicbd
     call g_font -copy_fonts ms georgia georgia georgiab georgiai georgiaz
     call g_font -copy_fonts ms sans micross
     call g_font -copy_fonts ms sylfaen sylfaen
     call g_font -copy_fonts ms tahoma tahoma tahomabd
     call g_font -copy_fonts ms trebuc trebuc trebucbd trebucbi trebucit
     call g_font -copy_fonts ms verdana verdana verdanab verdanai verdanaz
   REM Monotype fonts: ........................................................
     call g_font -copy_fonts mt aharoni ahronbd
     call g_font -copy_fonts mt andalus andlso
     call g_font -copy_fonts mt arial arial arialbd arialbi ariali
     call g_font -copy_fonts mt artro artrbdo artro
     call g_font -copy_fonts mt cour cour courbd courbi couri
     call g_font -copy_fonts mt david david davidbd davidtr
     call g_font -copy_fonts mt frank frank
     call g_font -copy_fonts mt garamond gara garabd garait
     call g_font -copy_fonts mt gothic gothic gothicb gothicbi gothici
     call g_font -copy_fonts mt impact impact
     call g_font -copy_fonts mt levenim lvnm lvnmbd
     call g_font -copy_fonts mt miriam mriam mriamc mriamfx mriamtr
     call g_font -copy_fonts mt narkisim nrkis
     call g_font -copy_fonts mt rod rod rodtr
     call g_font -copy_fonts mt simpo simpbdo simpfxo simpo
     call g_font -copy_fonts mt times times timesbd timesbi timesi
     call g_font -copy_fonts mt trado tradbdo trado     
   REM ........................................................................
     set GMS_MISS=%GMS_SETTING%\fontmiss.log
       echo.>> "%GMS_MISS%"
       echo %arg%%arg%>> "%GMS_MISS%"
       echo. %GMS_SETTING%>> "%GMS_MISS%"
     set arg=
   REM Now copying *.ttf from %GMS_FONTS% to %windir%\Fonts:
   REM Log file for installed fonts: ..........................................
     set GMS_INST=%GMS_SETTING%\fontinst.log
       echo  fontinst.log - Installed fonts in %windir%\Fonts>> "%GMS_INST%"
     set arg=////////////////////////////////////////
     if "%OS%" == "Windows_9x" set arg=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
     if "%winbootdir%" == "." set arg=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
       echo %arg%%arg%>> "%GMS_INST%"
       echo.>> "%GMS_INST%"
   REM Bigelow & Holmes fonts: ................................................
     call g_font -install_win bh lhandw lhandw
     call g_font -install_win bh lsans lsansi
   REM Bitstream fonts: .......................................................
     call g_font -install_win bt parkave parkave
     call g_font -install_win bt zapfchan bzcb bzcm
   REM Monotype fonts: ........................................................
     call g_font -install_win mt courthai crmthai crpthai   
   REM Public domain fonts: ...................................................
     call g_font -install_win pub ayummy ayummy
     call g_font -install_win pub beauti beauti
     call g_font -install_win pub cardo cardo
     call g_font -install_win pub champ champ
     call g_font -install_win pub garamond fgmr fgmri fgmb fgmbi
     call g_font -install_win pub gentium genr geni
     call g_font -install_win pub shree ass1 ass2 ban1 ban2
     call g_font -install_win pub shree dev1 dev2 guj1 guj2
     call g_font -install_win pub shree kan1 kan2 mal1 mal2
     call g_font -install_win pub shree ori1 ori2 pun1 pun2
     call g_font -install_win pub shree tam1 tam2 tel1 tel2
     call g_font -install_win pub shusha shusha     
   REM ........................................................................
     set GMS_INST=%GMS_SETTING%\fontinst.log
       echo.>> "%GMS_INST%"
       echo %arg%%arg%>> "%GMS_INST%"
       echo. %GMS_SETTING%>> "%GMS_INST%"
     set arg=
   goto exit
 :fi_xf
 
 REM Install fonts: -----------------------------------------------------------

 REM TDS: ../fonts/fonttype/supplier/typeface
 REM where fonttype = afm, tfm, type1 (for pfa and pfb), ttf, vf.

 REM According to the TeX directory structure, afm and pfa / pfb as well as ttf
 REM files are stored in different trees. - Copies of them must be collected at
 REM a common place, the tfm directory. The ttf fonts need computing of afm fi-
 REM les first, before tfm and vf files can be created. After processing of the
 REM metrics, all vf files are moved to the vf directory, while the pfa/pfb and
 REM afm copies are deleted.  The "core" font metrics get processed during this
 REM procedure, too.
 REM The tfm and vf metrics that have been processed algorithmically are  *not*
 REM stored in supplier/typeface subfolders, but in the top level of the tfm or
 REM vf tree.  At the beginning of the metric building process,  the top levels
 REM of the tfm and vf trees are cleared, but files in subfolders remain.

 REM Handle typeface: ---------------------------------------------------------
 
 if not %1 == -handle_typeface goto fi_ht
   REM %2 fonttype
   REM %3 supplier
   REM %4 typeface
   if "%4" == "_ignore_" goto exit
   if "%4" == "_IGNORE_" goto exit
   if "%4" == "cm" goto exit
   if "%4" == "Cm" goto exit
   if "%4" == "CM" goto exit   
   if not "%OS%" == "" goto else_ht
     if "%GMS_DRDOS%" == "" if not exist %GMS_FONTS%\%2\%3\%4\%any% goto exit
     cd %GMS_FONTS%\%2\%3\%4
     if exist *.%2 copy *.%2 %GMS_FONTS%\tfm > nul
     if not %2 == type1 goto fi_ht1
       if exist *.pfa copy *.pfa %GMS_FONTS%\tfm > nul
       if exist *.pfb copy *.pfb %GMS_FONTS%\tfm > nul
     :fi_ht1
     goto exit
   :else_ht   
     if not exist "%GMS_FONTS%\%2\%3\%4\%any%" goto exit
     cd "%GMS_FONTS%\%2\%3\%4"
     if exist *.%2 copy *.%2 "%GMS_FONTS%\tfm" > nul
     if not %2 == type1 goto fi_ht2
       if exist *.pfa copy *.pfa "%GMS_FONTS%\tfm" > nul
       if exist *.pfb copy *.pfb "%GMS_FONTS%\tfm" > nul
     :fi_ht2
     goto exit
 :fi_ht

 REM Handle supplier: ---------------------------------------------------------
 
 if not %1 == -handle_supplier goto fi_hs
   REM %2 fonttype
   REM %3 supplier
   if "%3" == "_ignore_" goto exit
   if "%3" == "_IGNORE_" goto exit
   if not "%OS%" == "" goto elsehs1
     if "%GMS_DRDOS%" == "" if not exist %GMS_FONTS%\%2\%3\%any% goto exit
     cd %GMS_FONTS%\%2\%3
     if exist *.%2 copy *.%2 %GMS_FONTS%\tfm > nul
     goto fi_hs1
   :elsehs1
     if not exist "%GMS_FONTS%\%2\%3\%any%" goto exit
     cd "%GMS_FONTS%\%2\%3"
     if exist *.%2 copy *.%2 "%GMS_FONTS%\tfm" > nul
   :fi_hs1   
   if not %2 == type1 goto fi_hs2
   if not "%OS%" == "" goto elsehs2
     if exist *.pfa copy *.pfa %GMS_FONTS%\tfm > nul
     if exist *.pfb copy *.pfb %GMS_FONTS%\tfm > nul
     goto fi_hs2
   :elsehs2
     if exist *.pfa copy *.pfa "%GMS_FONTS%\tfm" > nul
     if exist *.pfb copy *.pfb "%GMS_FONTS%\tfm" > nul
   :fi_hs2   
   call g_dos -for_folder call g_font -handle_typeface %2 %3
   if exist each.bat call each
   if not "%OS%" == "" goto elsehs3
     cd %GMS_FONTS%\%2\%3
     goto fi_hs3
   :elsehs3
     cd "%GMS_FONTS%\%2\%3"
   :fi_hs3  
   if exist each.bat del each.bat
   goto exit
 :fi_hs

 REM Copy font files to tfm top level: ----------------------------------------
 
 if not %1 == -copy_to_tfm goto fi_ctt
   REM %2 fonttype
   if "%2" == "_ignore_" goto exit
   if "%2" == "_IGNORE_" goto exit
   if not "%OS%" == "" goto elsect1
     if "%GMS_DRDOS%" == "" if not exist %GMS_FONTS%\%2\%any% goto exit
     cd %GMS_FONTS%\%2
     if exist *.%2 copy *.%2 %GMS_FONTS%\tfm > nul
     goto fi_ct1
   :elsect1
     if not exist "%GMS_FONTS%\%2\%any%" goto exit
     cd "%GMS_FONTS%\%2"
     if exist *.%2 copy *.%2 "%GMS_FONTS%\tfm" > nul
   :fi_ct1
   if not %2 == type1 goto fi_ct2
   if not "%OS%" == "" goto elsect2
     if exist *.pfa copy *.pfa %GMS_FONTS%\tfm > nul
     if exist *.pfb copy *.pfb %GMS_FONTS%\tfm > nul
     goto fi_ct2
   :elsect2     
     if exist *.pfa copy *.pfa "%GMS_FONTS%\tfm" > nul
     if exist *.pfb copy *.pfb "%GMS_FONTS%\tfm" > nul     
   :fi_ct2   
   call g_dos -for_folder call g_font -handle_supplier %2
   if exist each.bat call each   
   if not "%OS%" == "" goto elsect3
     cd %GMS_FONTS%\%2
     goto fi_ct3
   :elsect3
     cd "%GMS_FONTS%\%2"
   :fi_ct3   
   if exist each.bat del each.bat
   goto exit
 :fi_ctt 

 REM Build any font: ----------------------------------------------------------

 if not %1 == -build goto fi_bf
   REM %2: glyph file name
   REM %3: encoding
   REM %4: core/eroc/embed/corefamily/embedfamily mark
   REM %5: extension factor
   REM %6: slanting factor   
   REM %7: new name (or 'none')
   REM %8: new suffix (optional)
   set enc=%3
   if "%2" == "*.%4" goto fi_bf1
 REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
 set glyph=%2
 REM Get font face file base name from glyph file name:
 echo %glyph%> font_tmp.txt
 sed "s/\..*$//;s/^/set GMS_BASE=/" < font_tmp.txt > map_tmp.bat
 if exist map_tmp.bat call map_tmp
 REM Modify name:
 set esab=%GMS_BASE%
 if "%7" == "" goto fi_at0
   if %7 == none set esab=%esab%%8
   if not %7 == none set esab=%7
 :fi_at0
 REM Change encoding for non-latin fonts: .....................................
 if "%OS%" == "" set fo=%GMS_TEMP%\fo.bat
 if not "%OS%" == "" set fo="%GMS_TEMP%\fo.bat"
 REM if exist %fo% goto fiat00
   if "%OS%" == "" set fi=%GMS_SETTING%\encoding.cfg
   if not "%OS%" == "" set fi="%GMS_SETTING%\encoding.cfg"
   if "%OS%" == "" set fq=%GMS_TEMP%\fq.bat
   if not "%OS%" == "" set fq="%GMS_TEMP%\fq.bat"
   set myif=if
   sed "s/\#.*$//;/^ *$/d;s/^[ \t]*//;s/:/ set enc=/" <%fi% >%fq%
   REM sed "s/=\ */=/;s/^/%myif% %%GMS_BASE%% == /" <%fq% >%fo%
   sed "s/=\ */=/;s/^/%myif% %GMS_BASE% == /" <%fq% >%fo%
   if "%OS%" == "" if exist %fq% del %fq%
   if not "%OS%" == "" if exist "%fq%" del "%fq%"
   if not "%OS%" == "" goto fiat01
     REM Lowercase conversion: ................................................
     if "%OS%" == "" set fl=%GMS_TEMP%\fl.bat
     if not "%OS%" == "" set fl="%GMS_TEMP%\fl.bat"
     copy %fo% %fl% > nul
     set fa=ABCDEFGHIJKLMNOPQRSTUVWXYZ
     set fb=abcdefghijklmnopqrstuvwxyz
     sed "y/%fa%/%fb%/" <%fl% >%fo%
     if exist %fl% del %fl%
     set fu=
     set fa=
     set fb=
     set fl=
   :fiat01
   set myif=
   set fq=
   set fi=
 :fiat00
 if exist %fo% call %fo%
 set fo=
 REM Run ttf2afm: .............................................................
 if "%OS%" == "" if not exist %GMS_BASE%.ttf goto fi_bf2
 if not "%OS%" == "" if not exist "%GMS_BASE%.ttf" goto fi_bf2
   if "%OS%" == "" set ttfarg1=%GMS_ROOT%\data\enc\%enc%.enc
   if not "%OS%" == "" set ttfarg1="%GMS_ROOT%\data\enc\%enc%.enc"
   if "%OS%" == "" set ttfarg2=%GMS_BASE%.afm
   if not "%OS%" == "" set ttfarg2="%GMS_BASE%.afm"
   echo ttf2afm -e %ttfarg1% -o %ttfarg2% %glyph%>>l
   ttf2afm -e %ttfarg1% -o %ttfarg2% %glyph%>nul
   set ttfarg1=
   set ttfarg2=
   if "%OS%" == "" goto thenbf2      
   if "%OS%" == "Windows_9x" goto thenbf2
   goto fi_bf2
 :thenbf2
   REM Remove warning messages: 
   cls
   echo  Running:      GMS setup ... 
   if "%OS%" == "" type %GMS_SETTING%\writing.scn
   if not "%OS%" == "" type "%GMS_SETTING%\writing.scn"
   echo  %GMS_FOLDER%
 :fi_bf2
 REM Define afm2tfm arguments: ................................................
 if "%OS%" == "" if not exist %GMS_BASE%.afm goto fi_bf4
 if not "%OS%" == "" if not exist "%GMS_BASE%.afm" goto fi_bf4
   REM A redirection symbol (" < CP1252.enc ") is included in afm2tfm's
   REM output, so afm2tfm must be put into its argument variable:
   if not "%OS%" == "" goto fiat0w
     set arguments=afm2tfm .\%GMS_BASE%.afm
     set arguments=%arguments% -T %GMS_ROOT%\data\enc\%enc%.enc
     set arguments=%arguments% -v %esab%.vpl
     goto fiat0
   :fiat0w
   set arguments=afm2tfm .\%GMS_BASE%.afm
   set arguments=%arguments% -T "%GMS_ROOT%\data\enc\%enc%.enc"
   set arguments=%arguments% -v %esab%.vpl
   :fiat0
   REM Extend typeface: .......................................................
   if "%5" == "" goto fi_at1
   if %5 == 1 goto fi_at1
   if %5 == 1.0 goto fi_at1
   if %5 == 1.00 goto fi_at1
   if %5 == 1.000 goto fi_at1
   if %5 == 1.0000 goto fi_at1
   if %5 == 1.00000 goto fi_at1
   if %5 == hide goto fi_at1
     set arguments=%arguments% -e %5
   :fi_at1
   REM Slant typeface: ........................................................
   if "%6" == "" goto fi_at2
   if %6 == 0 goto fi_at2
   if %6 == 0.0 goto fi_at2
   if %6 == 0.00 goto fi_at2
   if %6 == 0.000 goto fi_at2
   if %6 == 0.0000 goto fi_at2
   if %6 == 0.00000 goto fi_at2
     set arguments=%arguments% -s %6
   :fi_at2
   REM Display font file base name: ...........................................
   set REPLY_OFFSET=0
   set REPLY_SIZE=82
   reply -banner 19 ""
   reply -banner 20 ""
   reply -banner 21 ""
   set REPLY_OFFSET=43
   set REPLY_SIZE=39
   reply -banner 17 "(%enc%) %GMS_BASE%"
   REM Run afm2tfm, build map item, eventually add glyph: .....................
   echo %arguments% _%esab%.tfm>>l
   %arguments% _%esab%.tfm>i
   if "%4" == "core" goto else_at3
   if "%4" == "eroc" goto else_at3
     sed "s/<.*$/<%enc%.enc <%glyph%/" <i >m
     if "%OS%" == "" type m >> %GMS_SETTING%\unsort.map
     if "%OS%" == "" goto fi_at3
       type m >>"%GMS_SETTING%\unsort.map"
     goto fi_at3
   :else_at3
     sed "s/<.*$/<%enc%.enc/" <i >m
     if "%OS%" == "" type m >> %GMS_SETTING%\unsort.map
     if "%OS%" == "" goto fi_at3
     type m >>"%GMS_SETTING%\unsort.map"
   :fi_at3
   set arguments=
   REM  Run vptovf, move processed core afm fonts to _trans_: .................
   echo.
   echo vptovf %esab%.vpl %esab%.vf %esab%.tfm>>l
   vptovf %esab%.vpl %esab%.vf %esab%.tfm
   if not "%4" == "eroc" goto fi_at4
   if not "%OS%" == "" goto fiat4w
     if exist %GMS_BASE%.afm copy %GMS_BASE%.afm ..\_trans_ > nul
     if exist %GMS_BASE%.afm del %GMS_BASE%.afm
     goto fi_at4
     :fiat4w
     if exist "%GMS_BASE%.afm" copy "%GMS_BASE%.afm" ..\_trans_ > nul
     if exist "%GMS_BASE%.afm" del "%GMS_BASE%.afm"
     :fi_at4
   :fi_bf4
   set GMS_BASE=
   set esab=
 set glyph=
 REM ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
   :fi_bf1
   echo.>>l
   set enc=
   goto exit
 :fi_bf

 REM Build specifically encoded fonts: ----------------------------------------

 if not %1 == -build_encode goto fi_enc
   REM %2: encoding
   if "%2" == "" goto exit
     for %%i in (%2*.afm) do call g_font -build %%i %2 eroc
     for %%i in (%2*.pfa) do call g_font -build %%i %2 embed
     for %%i in (%2*.pfb) do call g_font -build %%i %2 embed
     for %%i in (%2*.ttf) do call g_font -build %%i %2 embed
   goto exit
 :fi_enc

 REM Build transformed fonts: -------------------------------------------------

 if not %1 == -build_trans goto fi_trs
   REM %2: base name 
   REM %3: encoding
   REM %4: core/embed mark
   REM %5: extension factor
   REM %6: slanting factor
   REM %7: new name (or 'none')
   REM %8: new suffix (optional)
   if "%4" == "" goto exit
   REM Display font file base name: ...........................................
   set REPLY_OFFSET=14
   set REPLY_SIZE=68
   reply -banner 17 "*.tfm - TeX Font Metrics ... (%3) %2"
   REM These lines contain cleaning spaces up to column 79:
   echo.                                                                       
   echo.                                                                       
   echo.                                                                       
   echo.                                                                       
   echo.                                                                       
   if not %4 == core goto fi_trs1
     REM This is only possible if a type1 glyph file is present:
     if exist %2.afm call g_font -build %2.pfa %3 %4 %5 %6 %7 %8
   :fi_trs1
   if not %4 == corefamily goto fi_trs2
     for %%i in (%2*.afm) do call g_font -build %%i %3 embed %5 %6 %7 %8
   :fi_trs2
   if not %4 == embed goto fi_trs3
     if exist %2.pfa call g_font -build %2.pfa %3 %4 %5 %6 %7 %8
     if exist %2.pfb call g_font -build %2.pfb %3 %4 %5 %6 %7 %8
     if exist %2.ttf call g_font -build %2.ttf %3 %4 1.0 0.0 %7 %8
   :fi_trs3
   if not %4 == embedfamily goto fi_trs4
     for %%i in (%2*.pfa) do call g_font -build %%i %3 embed %5 %6 %7 %8
     for %%i in (%2*.pfb) do call g_font -build %%i %3 embed %5 %6 %7 %8
     for %%i in (%2*.ttf) do call g_font -build %%i %3 embed %5 %6 %7 %8
   :fi_trs4
   goto exit
 :fi_trs

 REM Build all fonts: ---------------------------------------------------------

 if not %1 == -build_all goto fi_f1
   set REPLY_BANNER=0
   set REPLY_TEXT=7
   set REPLY_OFFSET=0
   set REPLY_SIZE=82
   if not "%2" == "" goto fi_af0
     cls
     echo  %GMS_FILE%
     if "%OS%" == "" type %GMS_SETTING%\desktop.scn
     if not "%OS%" == "" type "%GMS_SETTING%\desktop.scn"
     echo  GMS: Running font metric processor ...
     reply -banner 14
     reply -banner 15 "Please remember to re-initialize the format"
     set REPLY_OFFSET=45
     set REPLY_SIZE=37
     reply -banner 15 "file after re-writing the font map"
   :fi_af0
   set REPLY_OFFSET=0
   set REPLY_SIZE=82
   reply -banner 22
   reply -banner 16
   reply -banner 21
   reply -banner 17
   reply -banner 20
   reply -banner 18
   reply -banner 19
   REM Delete old tfm and vf; get afm, ttf, pfa/pfb: ..........................
   set REPLY_OFFSET=0
   set REPLY_SIZE=32
   reply -banner 17 "Collecting:   Font files ..."
   echo.
   echo.
   if not "%OS%" == "" goto else_os
     echo                These processes require several megabytes of free
     echo                disk space, depending on the number of fonts.
     goto fi_os
   :else_os 
     echo                These processes may run faster if there is no file 
     echo                manager task to be updated in the background.
   :fi_os
   if "%OS%" == "" if exist %GMS_FONTS%\tfm\%any% cd %GMS_FONTS%\tfm
   if not "%OS%" == "" if exist "%GMS_FONTS%\tfm\%any%" cd "%GMS_FONTS%\tfm"
   if not "%GMS_DRDOS%" == "" cd %GMS_FONTS%\tfm
   if exist *.tfm del *.tfm
   if "%OS%" == "" if exist %GMS_FONTS%\vf\%any% cd %GMS_FONTS%\vf
   if not "%OS%" == "" if exist "%GMS_FONTS%\vf\%any%" cd "%GMS_FONTS%\vf"
   if not "%GMS_DRDOS%" == "" cd %GMS_FONTS%\vf
   if exist *.vf del *.vf
   set REPLY_OFFSET=14
   set REPLY_SIZE=68
   reply -banner 17 "*.ttf - True Type Fonts ..."
   call g_font -exchange_fonts called_by gmssetup
   call g_font -copy_to_tfm ttf
   reply -banner 17 "*.pf* - Postscript Fonts ... Ascii/Binary"
   call g_font -copy_to_tfm type1
   reply -banner 17 "*.afm - Adobe Font Metrics ..."
   call g_font -copy_to_tfm afm
   REM Get new tfm and vf: ....................................................
   set REPLY_OFFSET=0
   set REPLY_SIZE=14
   reply -banner 17 Computing:
   set REPLY_OFFSET=14
   set REPLY_SIZE=68
   reply -banner 17 "*.tfm - TeX Font Metrics ..."
   if "%OS%" == "" if exist %GMS_SETTING%\%any% cd %GMS_SETTING%
   if not "%OS%" == "" if exist "%GMS_SETTING%\%any%" cd "%GMS_SETTING%"
   if not "%GMS_DRDOS%" == "" cd %GMS_SETTING%
   if exist font.map del font.map
   if exist unsort.map del unsort.map       
   if "%OS%" == "" if exist %GMS_FONTS%\%any% cd %GMS_FONTS%
   if not "%OS%" == "" if exist "%GMS_FONTS%\%any%" cd "%GMS_FONTS%"
   if not "%GMS_DRDOS%" == "" cd %GMS_FONTS%
   if "%OS%" == "Windows_9x" goto th_98_1
     REM %any% in next line for Dos 3x:
     if exist _trans_\%any% echo j | del _trans_ > nul
     goto fi_98_1
   :th_98_1
     if exist _trans_ del _trans_ > nul     
   :fi_98_1
   if not "%GMS_DRDOS%" == "" echo Delete me! > _trans_\deleteme.txt > nul
   if not exist _trans_\%any% md _trans_
   set REPLY_OFFSET=0
   set REPLY_SIZE=80
   reply -banner 18 ""
   set REPLY_SIZE=68
   set REPLY_OFFSET=14
   REM Process font files by encoding: ........................................
   if "%OS%" == "" if exist %GMS_ROOT%\data\enc\%any% cd %GMS_ROOT%\data\enc
   if not "%OS%" == "" if exist "%GMS_ROOT%\%any%" cd "%GMS_ROOT%\" > nul
   if not "%OS%" == "" if exist "data\enc\%any%" cd "data\enc"
   if not "%GMS_DRDOS%" == "" goto else_dr 
     REM 'dir /b' fails on MS-DOS 3x, so use 'mdir':
     if "%GMS_DRDOS%" == "" if "%OS%" == "" set argdr=mdir /b
     if "%GMS_DRDOS%" == "" if not "%OS%" == "" set argdr=dir /b
     echo j | %argdr% *.enc > enc.txt
     sed "s/^/call g_font -build_encode /;s/\..*$//" < enc.txt > enc.bat
     set argdr=
     if "%OS%" == "" if exist enc.bat copy enc.bat %GMS_FONTS%\tfm > nul
     if not "%OS%" == "" if exist enc.bat copy enc.bat "%GMS_FONTS%\tfm">nul
     goto fi_dr
   :else_dr
     echo j | xdir *.enc /b > enc.txt
     sed "s/^../call g_font -build_encode /;s/\..*$//" < enc.txt > enc.bat
     if exist enc.bat copy enc.bat %GMS_FONTS%\tfm > nul
   :fi_dr
   if exist enc.bat del enc.bat
   if exist enc.txt del enc.txt
   if "%OS%" == "" if exist %GMS_FONTS%\tfm\%any% cd %GMS_FONTS%\tfm
   if not "%OS%" == "" if exist "%GMS_FONTS%\tfm\%any%" cd "%GMS_FONTS%\tfm"
   if not "%GMS_DRDOS%" == "" cd %GMS_FONTS%\tfm
   if exist enc.bat call enc
   if exist enc.bat del enc.bat
   REM Process font files by type: ............................................
   if "%OS%" == "" if exist %GMS_FONTS%\tfm\%any% cd %GMS_FONTS%\tfm
   if not "%OS%" == "" if exist "%GMS_FONTS%\tfm\%any%" cd "%GMS_FONTS%\tfm"
   if not "%GMS_DRDOS%" == "" cd %GMS_FONTS%\tfm
   for %%i in (pcr*.afm) do call g_font -build %%i %GMS_CODEPAGE% eroc
   for %%i in (phv*.afm) do call g_font -build %%i %GMS_CODEPAGE% eroc
   for %%i in (ptm*.afm) do call g_font -build %%i %GMS_CODEPAGE% eroc
   for %%i in (*.pfa) do call g_font -build %%i %GMS_CODEPAGE% embed
   for %%i in (*.pfb) do call g_font -build %%i %GMS_CODEPAGE% embed
   for %%i in (*.ttf) do call g_font -build %%i %GMS_CODEPAGE% embed
   REM Process transformed files: .............................................
   if "%OS%" == "" if exist %GMS_FONTS%\_trans_\%any% cd %GMS_FONTS%\_trans_
   if not "%OS%" == "" if exist "%GMS_FONTS%\%any%" cd "%GMS_FONTS%"
   if not "%OS%" == "" if exist "_trans_\%any%" cd "_trans_"
   if not "%GMS_DRDOS%" == "" cd %GMS_FONTS%\_trans_
   if exist *.afm copy *.afm ..\tfm > nul
   if exist *.afm del *.afm
   if "%OS%" == "" if exist %GMS_FONTS%\%any% cd %GMS_FONTS%
   if not "%OS%" == "" if exist "%GMS_FONTS%\%any%" cd "%GMS_FONTS%"
   if not "%GMS_DRDOS%" == "" cd %GMS_FONTS%
   rmdir _trans_
   if "%OS%" == "Windows_9x" goto th_98_2
     if exist _trans_ echo j | del _trans_ > nul
     goto fi_98_2
   :th_98_2
     if exist _trans_ del _trans_ > nul     
   :fi_98_2
   if "%OS%" == "" if exist %GMS_SETTING%\%any% cd %GMS_SETTING%
   if not "%OS%" == "" if exist "%GMS_SETTING%\%any%" cd "%GMS_SETTING%"
   if not "%GMS_DRDOS%" == "" cd %GMS_SETTING%
   if not exist font.cfg goto fi_af
     sed "s/^.*#.*$//;/^ *$/d;" < font.cfg > snart.gfc
     sed "s/^/call g_font -build_trans/" < snart.gfc > trans.bat
     if exist snart.gfc del snart.gfc
     if "%OS%" == "" if exist trans.bat copy trans.bat %GMS_FONTS%\tfm>nul
   if not "%OS%" == "" if exist trans.bat copy trans.bat "%GMS_FONTS%\tfm">nul
     if exist trans.bat del trans.bat
     if "%OS%" == "" if exist %GMS_FONTS%\tfm\%any% cd %GMS_FONTS%\tfm
     if not "%OS%" == "" if exist "%GMS_FONTS%\tfm\%any%" cd "%GMS_FONTS%\tfm"
     if not "%GMS_DRDOS%" == "" cd %GMS_FONTS%\tfm
     if exist trans.bat call trans
     if exist trans.bat del trans.bat
   :fi_af
   if "%OS%" == "" cd %GMS_TEMP% > nul
   if not "%OS%" == "" cd "%GMS_TEMP%" > nul
   if "%OS%" == "" if exist %GMS_TEMP%\%any% cd %GMS_TEMP%
   if not "%OS%" == "" if exist "%GMS_TEMP%\%any%" cd "%GMS_TEMP%"
   if not "%GMS_DRDOS%" == "" cd %GMS_TEMP%
   if exist fo.bat del fo.bat > nul
   REM Install virtual fonts (and clean up the tfm folder): ...................
   set REPLY_OFFSET=0
   set REPLY_SIZE=15
   reply -banner 17 Installing:
   set REPLY_OFFSET=14
   set REPLY_SIZE=68
   reply -banner 17 "*.vf* - Virtual Fonts ... %GMS_CODEPAGE%"
   if "%OS%" == "" if exist %GMS_FONTS%\tfm\%any% cd %GMS_FONTS%\tfm
   if not "%OS%" == "" if exist "%GMS_FONTS%\tfm\%any%" cd "%GMS_FONTS%\tfm"
   if not "%GMS_DRDOS%" == "" cd %GMS_FONTS%\tfm
   if exist *.afm del *.afm
   if exist *.pfa del *.pfa
   if exist *.pfb del *.pfb
   if exist *.ttf del *.ttf
   if exist *.vpl del *.vpl
   if "%OS%" == "" if exist *.vf copy *.vf %GMS_FONTS%\vf > nul
   if not "%OS%" == "" if exist *.vf copy *.vf "%GMS_FONTS%\vf" > nul
   if exist *.vf del *.vf
   if exist font_tmp.txt del font_tmp.txt
   if exist map_tmp.bat del map_tmp.bat
   if exist i del i
   if exist m del m
   if exist short.txt del short.txt
   if exist short.bat del short.bat
   REM Build font map (and log): ..............................................
   set slashline=////////////////////////////////////////////////////////////
   if "%OS%" == "Windows_9x" set slashline=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
   if "%winbootdir%" == "." set slashline=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
   if "%OS%" == "" if exist %GMS_SETTING%\%any% cd %GMS_SETTING%
   if not "%OS%" == "" if exist "%GMS_SETTING%\%any%" cd "%GMS_SETTING%"
   if exist encoding.bat del encoding.bat
   if "%OS%" == "" goto fi_f11
     if "%OS%" == "Windows_9x" goto fi_f11
       echo %% font.log - Warnings, errors, missing glyphs> font.log
       echo %% %slashline%%slashline%>> font.log
   :fi_f11
   set arguments=%GMS_FONTS%\[font-type]\[supplier]\[font-family]
   echo %% font.map - %arguments%> head.map
   set arguments=
   if "%OS%" == "" goto fi_f13
   if "%OS%" == "Windows_9x" goto fi_f12
     echo %% /////////%slashline%%slashline%///////////>> head.map
   :fi_f12
   if not "%OS%" == "Windows_9x" goto fi_f13
     echo %% XXXXXXXXX%slashline%%slashline%XXXXXXXXXXX>> head.map
   :fi_f13
   echo.>> head.map
   echo %% Generated by Gerolf Markup Shredder (www.Gerolf.org)>>head.map
   echo.>> head.map
   echo %%  _[1]                  Base  name of  font files>> head.map
   echo %%   [2]                  PostScript font face name>> head.map
   echo %% " [3] ReEncodeFont "   PostScript encoding  name>> head.map
   echo %%  ([4]                  Encoding   file   [*.enc]>> head.map
   echo %%  ([5]                  Glyph file [*.pf*, *.ttf]>> head.map
   echo.>> head.map
   sed "s/(\[4\]/\<\[4\]/;s/(\[5\]/\<\[5\]/" < head.map > header.map
   if exist unsort.map sort < unsort.map > sort.map    
   copy header.map + sort.map font.pam > nul
   sed "s/\\/\//g" < font.pam > font.map
   if not "%OS%" == "" goto fi_no89
     if "%OS%" == "" sed "/^_.\{8\} /d" < font.map > font.pam
     if "%OS%" == "" sed "/^_.\{9\} /d" < font.pam > font.map
   :fi_no89
   if exist font.pam del font.pam
   if exist font.pam del font.pam
   if exist sort.map del sort.map
   if exist header.map del header.map
   if exist unsort.map del unsort.map
   if exist head.map del head.map
   if "%OS%" == "" if exist %GMS_FONTS%\tfm\%any% cd %GMS_FONTS%\tfm
   if not "%OS%" == "" if exist "%GMS_FONTS%\tfm\%any%" cd "%GMS_FONTS%\tfm"
   if not "%GMS_DRDOS%" == "" cd %GMS_FONTS%\tfm
   if not exist l goto fi_nofm
     if "%OS%" == "" copy l %GMS_SETTING%\fontmap.log > nul
     if not "%OS%" == "" copy l "%GMS_SETTING%\fontmap.log" > nul
     if exist l del l > nul
   :fi_nofm
   set slashline=
   set REPLY_OFFSET=0
   set REPLY_SIZE=15
   reply -banner 17 Writing: 
   set REPLY_OFFSET=14
   set REPLY_SIZE=68   
   reply -banner 17 "  %GMS_SETTING%\font.map"
   if "%OS%" == "" if exist %GMS_SETTING%\%any% cd %GMS_SETTING%
   if not "%OS%" == "" if exist "%GMS_SETTING%\%any%" cd "%GMS_SETTING%"
   if "%OS%" == "" if exist font.log del font.log > nul
   set i=
   set l=
   set m=
   goto exit
 :fi_f1

 REM Not found: ---------------------------------------------------------------

 :else
   call l_banner -no_action g_font %1 
 :fi

 :exit

