 REM g_color.bat
 REM ===========

 REM This file is part of Gerolf Markup Shredder,
 REM written by G. D. Brettschneider (1999-2006).

 REM set GMSdateG_COLOR=20060927

 REM Prologue: ================================================================

 REM Not running:

 if not "%GMS_BATCH%" == "" goto fi_nr
   echo  G e r o l f   M a r k u p   S h r e d d e r   (g_color)   . . .
   pause > nul
   gerolf 2> nul
   goto exit
 :fi_nr

 REM Debug:

 if "%OS%" == "" goto fi_db
 if -%GMS_DEBUG% == - goto fi_db
 if %GMS_DEBUG% == Z echo %0 (%1) (%2) (%3) (%4) (%5) (%6) (%7) (%8)>> "%Z%"
 if %GMS_DEBUG% == X goto then_db
 if not %GMS_DEBUG% == Y goto fi_db
 :then_db
   call l_banner -debug g_color %1 %2 %3 %4
 :fi_db

 REM Chapters: ================================================================

 REM Not defined:

 if not "%1" == "" goto fi_nd
   call l_banner -no_action g_color
   goto exit
 :fi_nd

 REM Resize: ------------------------------------------------------------------

 if %1 == -resize goto then_rs
 if %1 == -build goto then_rs
 if not %1 == -remove goto fi_rs
 :then_rs
   set REPLY_OFFSET=26
   set REPLY_SIZE=20
   set REPLY_ITEMS=8
   if %1 == -build goto then_b
   if %1 == -remove goto then_r
   goto exit
 :fi_rs

 REM Build: -------------------------------------------------------------------

 if not %1 == -build goto fi_b
 :then_b
   call l_box -build called_by g_color %1
   call l_banner -lower -color
   call l_color -build 
   set GMS_HOT=Q
   call l_color -update Q Q called_by g_color %1
   set REPLY_MODULE=g_color
   set REPLY_ACTION=-update
   set GMS_RECEIVE=1
   goto exit
 :fi_b 

 REM Remove: ------------------------------------------------------------------

 if not %1 == -remove goto fi_r
 :then_r
   call l_box -remove called_by g_color %1
   call g_menu -remove called_by g_color %1
   call g_rain -remove called_by g_color %1
   call l_desk -remove called_by g_color %1
   set REPLY_MODULE=g_palet
   set REPLY_ACTION=-build
   set REPLY_OFFSET=0 
   set REPLY_SIZE=0
   set REPLY_ITEMS=0
     reply -random 2 
   set GMS_RECEIVE=1
   set GMS_RETURN=1
   goto exit
 :fi_r

 REM Update: ------------------------------------------------------------------

 if not %1 == -update goto fi_u
 REM Cold:
   if not "%3" == "" goto else_u1
     set GMS_COLD=%GMS_HOT%
     goto fi_u1 
   :else_u1
     set GMS_COLD=%3
   :fi_u1
 REM Hot:
   if not "%2" == "" goto else_u2
     call l_banner -no_hot g_color
     goto fi_u2
   :else_u2
     set GMS_HOT=Q
     if %2 == T set GMS_HOT=T
     if %2 == t set GMS_HOT=T
     if %2 == 1 set GMS_HOT=T
     if %2 == H set GMS_HOT=H
     if %2 == h set GMS_HOT=H
     if %2 == 2 set GMS_HOT=H
     if %2 == P set GMS_HOT=P
     if %2 == p set GMS_HOT=P
     if %2 == 3 set GMS_HOT=P
     if %2 == B set GMS_HOT=B
     if %2 == b set GMS_HOT=B
     if %2 == 4 set GMS_HOT=B
     if %2 == S set GMS_HOT=S
     if %2 == s set GMS_HOT=S
     if %2 == 5 set GMS_HOT=S
     if %2 == D set GMS_HOT=D
     if %2 == d set GMS_HOT=D
     if %2 == 6 set GMS_HOT=D
     if %2 == L set GMS_HOT=L
     if %2 == l set GMS_HOT=L
     if %2 == 7 set GMS_HOT=L
     if %2 == R set GMS_HOT=T
     if %2 == r set GMS_HOT=T
   :fi_u2
 REM Handle old, update new:
   if not %GMS_HOT% == %GMS_COLD% goto else_u3
     call g_color -handle %GMS_HOT% %GMS_COLD%
     goto fi_u3
   :else_u3
   REM Update colors:
     if "%4" == "" goto fi_u33
       if %GMS_COLD% == T set GMS_TEXT=%4
       if %GMS_COLD% == H set GMS_HOTKEY=%4 
       if %GMS_COLD% == P set GMS_PATTERN=%4
       if %GMS_COLD% == B set GMS_BANNER=%4
       if %GMS_COLD% == S set GMS_SHADE=%4
       if %GMS_COLD% == D set GMS_DESKTOP=%4
       if %GMS_COLD% == L set GMS_LETTER=%4
     :fi_u33
   REM Update color box:
     call l_color -update %GMS_HOT% %GMS_COLD%
   :fi_u3
   set GMS_RECEIVE=1
   goto exit
 :fi_u

 REM Handle: ------------------------------------------------------------------

 if not %1 == -handle goto fi_h
 :then_h

 REM Quit:
   if not %GMS_HOT% == Q goto fi_hq
     set arga=%REPLY_DESKTOP% %REPLY_PATTERN%
     set argb=%REPLY_BANNER% %REPLY_TEXT% 
     set argc=%REPLY_SHADE% %REPLY_HOTKEY% 
     set args=%arga% %argb% %argc% %REPLY_LETTER% 
       call g_palet -handle %args% called_by)_(g_color)_(%1
       call g_launch -build called_by g_color %1
       call g_color -remove called_by g_color %1
     set arga=
     set argb=
     set argc=
     set args=
     goto exit
   :fi_hq

 REM Text:
   if not %GMS_HOT% == T goto fi_ht
     call l_color -update - T
     reply -question 8 %GMS_TEXT% TT 1
     goto exit 
   :fi_ht

 REM Hotkey:
   if not %GMS_HOT% == H goto fi_hh
     call l_color -update - H
     reply -question 10 %GMS_HOTKEY% HH 2 
     goto exit
   :fi_hh

 REM Pattern:
   if not %GMS_HOT% == P goto fi_hp
     call l_color -update - P
     reply -question 12 %GMS_PATTERN% PP 3
     goto exit
   :fi_hp

 REM Banner:
   if not %GMS_HOT% == B goto fi_hb
     call l_color -update - B
     reply -question 14 %GMS_BANNER% BB 4
     goto exit
   :fi_hb

 REM Shadow:   
   if not %GMS_HOT% == S goto fi_hs
     call l_color -update - S
     reply -question 16 %GMS_SHADE% SS 5 
     goto exit
   :fi_hs

 REM Desktop:
   if not %GMS_HOT% == D goto fi_hd
     call l_color -update - D
     reply -question 18 %GMS_DESKTOP% DD 6
     goto exit
   :fi_hd

 REM Character:
   if not %GMS_HOT% == L goto fi_hl
     call l_color -update - L
     reply -question 20 %GMS_LETTER% LL 7 
     goto exit
   :fi_hl

 REM Not found:
   :else_h
     call l_banner -no_hotkey g_color %2
   :fi_h

 REM Not found: ---------------------------------------------------------------

 :else
   call l_banner -no_action g_color %1 
 :fi

 :exit
